/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.EnabledMetric;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScalingGroup {
    private String autoScalingGroupName;
    private String autoScalingGroupARN;
    private String launchConfigurationName;
    private Integer minSize;
    private Integer maxSize;
    private Integer desiredCapacity;
    private Integer defaultCooldown;
    private List<String> availabilityZones;
    private List<String> loadBalancerNames;
    private String healthCheckType;
    private Integer healthCheckGracePeriod;
    private List<Instance> instances;
    private Date createdTime;
    private List<SuspendedProcess> suspendedProcesses;
    private String placementGroup;
    private String vPCZoneIdentifier;
    private List<EnabledMetric> enabledMetrics;
    private String status;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public AutoScalingGroup withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public String getAutoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public void setAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
    }

    public AutoScalingGroup withAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
        return this;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public AutoScalingGroup withLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
        return this;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public AutoScalingGroup withMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public AutoScalingGroup withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public AutoScalingGroup withDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
        return this;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    public AutoScalingGroup withDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public AutoScalingGroup withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public AutoScalingGroup withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public List<String> getLoadBalancerNames() {
        if (this.loadBalancerNames == null) {
            this.loadBalancerNames = new ArrayList<String>();
        }
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
            return;
        }
        ArrayList<String> loadBalancerNamesCopy = new ArrayList<String>(loadBalancerNames.size());
        loadBalancerNamesCopy.addAll(loadBalancerNames);
        this.loadBalancerNames = loadBalancerNamesCopy;
    }

    public AutoScalingGroup withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.getLoadBalancerNames() == null) {
            this.setLoadBalancerNames(new ArrayList<String>(loadBalancerNames.length));
        }
        for (String value : loadBalancerNames) {
            this.getLoadBalancerNames().add(value);
        }
        return this;
    }

    public AutoScalingGroup withLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
        } else {
            ArrayList<String> loadBalancerNamesCopy = new ArrayList<String>(loadBalancerNames.size());
            loadBalancerNamesCopy.addAll(loadBalancerNames);
            this.loadBalancerNames = loadBalancerNamesCopy;
        }
        return this;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public void setHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public AutoScalingGroup withHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
        return this;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
    }

    public AutoScalingGroup withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public AutoScalingGroup withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public AutoScalingGroup withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public AutoScalingGroup withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public List<SuspendedProcess> getSuspendedProcesses() {
        if (this.suspendedProcesses == null) {
            this.suspendedProcesses = new ArrayList<SuspendedProcess>();
        }
        return this.suspendedProcesses;
    }

    public void setSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        if (suspendedProcesses == null) {
            this.suspendedProcesses = null;
            return;
        }
        ArrayList<SuspendedProcess> suspendedProcessesCopy = new ArrayList<SuspendedProcess>(suspendedProcesses.size());
        suspendedProcessesCopy.addAll(suspendedProcesses);
        this.suspendedProcesses = suspendedProcessesCopy;
    }

    public AutoScalingGroup withSuspendedProcesses(SuspendedProcess ... suspendedProcesses) {
        if (this.getSuspendedProcesses() == null) {
            this.setSuspendedProcesses(new ArrayList<SuspendedProcess>(suspendedProcesses.length));
        }
        for (SuspendedProcess value : suspendedProcesses) {
            this.getSuspendedProcesses().add(value);
        }
        return this;
    }

    public AutoScalingGroup withSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        if (suspendedProcesses == null) {
            this.suspendedProcesses = null;
        } else {
            ArrayList<SuspendedProcess> suspendedProcessesCopy = new ArrayList<SuspendedProcess>(suspendedProcesses.size());
            suspendedProcessesCopy.addAll(suspendedProcesses);
            this.suspendedProcesses = suspendedProcessesCopy;
        }
        return this;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public void setPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
    }

    public AutoScalingGroup withPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
        return this;
    }

    public String getVPCZoneIdentifier() {
        return this.vPCZoneIdentifier;
    }

    public void setVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
    }

    public AutoScalingGroup withVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
        return this;
    }

    public List<EnabledMetric> getEnabledMetrics() {
        if (this.enabledMetrics == null) {
            this.enabledMetrics = new ArrayList<EnabledMetric>();
        }
        return this.enabledMetrics;
    }

    public void setEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        if (enabledMetrics == null) {
            this.enabledMetrics = null;
            return;
        }
        ArrayList<EnabledMetric> enabledMetricsCopy = new ArrayList<EnabledMetric>(enabledMetrics.size());
        enabledMetricsCopy.addAll(enabledMetrics);
        this.enabledMetrics = enabledMetricsCopy;
    }

    public AutoScalingGroup withEnabledMetrics(EnabledMetric ... enabledMetrics) {
        if (this.getEnabledMetrics() == null) {
            this.setEnabledMetrics(new ArrayList<EnabledMetric>(enabledMetrics.length));
        }
        for (EnabledMetric value : enabledMetrics) {
            this.getEnabledMetrics().add(value);
        }
        return this;
    }

    public AutoScalingGroup withEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        if (enabledMetrics == null) {
            this.enabledMetrics = null;
        } else {
            ArrayList<EnabledMetric> enabledMetricsCopy = new ArrayList<EnabledMetric>(enabledMetrics.size());
            enabledMetricsCopy.addAll(enabledMetrics);
            this.enabledMetrics = enabledMetricsCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AutoScalingGroup withStatus(String status) {
        this.status = status;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName != null) {
            sb.append("AutoScalingGroupName: " + this.autoScalingGroupName + ", ");
        }
        if (this.autoScalingGroupARN != null) {
            sb.append("AutoScalingGroupARN: " + this.autoScalingGroupARN + ", ");
        }
        if (this.launchConfigurationName != null) {
            sb.append("LaunchConfigurationName: " + this.launchConfigurationName + ", ");
        }
        if (this.minSize != null) {
            sb.append("MinSize: " + this.minSize + ", ");
        }
        if (this.maxSize != null) {
            sb.append("MaxSize: " + this.maxSize + ", ");
        }
        if (this.desiredCapacity != null) {
            sb.append("DesiredCapacity: " + this.desiredCapacity + ", ");
        }
        if (this.defaultCooldown != null) {
            sb.append("DefaultCooldown: " + this.defaultCooldown + ", ");
        }
        if (this.availabilityZones != null) {
            sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        }
        if (this.loadBalancerNames != null) {
            sb.append("LoadBalancerNames: " + this.loadBalancerNames + ", ");
        }
        if (this.healthCheckType != null) {
            sb.append("HealthCheckType: " + this.healthCheckType + ", ");
        }
        if (this.healthCheckGracePeriod != null) {
            sb.append("HealthCheckGracePeriod: " + this.healthCheckGracePeriod + ", ");
        }
        if (this.instances != null) {
            sb.append("Instances: " + this.instances + ", ");
        }
        if (this.createdTime != null) {
            sb.append("CreatedTime: " + this.createdTime + ", ");
        }
        if (this.suspendedProcesses != null) {
            sb.append("SuspendedProcesses: " + this.suspendedProcesses + ", ");
        }
        if (this.placementGroup != null) {
            sb.append("PlacementGroup: " + this.placementGroup + ", ");
        }
        if (this.vPCZoneIdentifier != null) {
            sb.append("VPCZoneIdentifier: " + this.vPCZoneIdentifier + ", ");
        }
        if (this.enabledMetrics != null) {
            sb.append("EnabledMetrics: " + this.enabledMetrics + ", ");
        }
        if (this.status != null) {
            sb.append("Status: " + this.status + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupARN() == null ? 0 : this.getAutoScalingGroupARN().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getMinSize() == null ? 0 : this.getMinSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSize() == null ? 0 : this.getMaxSize().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCapacity() == null ? 0 : this.getDesiredCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCooldown() == null ? 0 : this.getDefaultCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : ((Object)this.getAvailabilityZones()).hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerNames() == null ? 0 : ((Object)this.getLoadBalancerNames()).hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckType() == null ? 0 : this.getHealthCheckType().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckGracePeriod() == null ? 0 : this.getHealthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : ((Object)this.getInstances()).hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getSuspendedProcesses() == null ? 0 : ((Object)this.getSuspendedProcesses()).hashCode());
        hashCode = 31 * hashCode + (this.getPlacementGroup() == null ? 0 : this.getPlacementGroup().hashCode());
        hashCode = 31 * hashCode + (this.getVPCZoneIdentifier() == null ? 0 : this.getVPCZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledMetrics() == null ? 0 : ((Object)this.getEnabledMetrics()).hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getAutoScalingGroupARN() == null ^ this.getAutoScalingGroupARN() == null) {
            return false;
        }
        if (other.getAutoScalingGroupARN() != null && !other.getAutoScalingGroupARN().equals(this.getAutoScalingGroupARN())) {
            return false;
        }
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getMinSize() == null ^ this.getMinSize() == null) {
            return false;
        }
        if (other.getMinSize() != null && !other.getMinSize().equals(this.getMinSize())) {
            return false;
        }
        if (other.getMaxSize() == null ^ this.getMaxSize() == null) {
            return false;
        }
        if (other.getMaxSize() != null && !other.getMaxSize().equals(this.getMaxSize())) {
            return false;
        }
        if (other.getDesiredCapacity() == null ^ this.getDesiredCapacity() == null) {
            return false;
        }
        if (other.getDesiredCapacity() != null && !other.getDesiredCapacity().equals(this.getDesiredCapacity())) {
            return false;
        }
        if (other.getDefaultCooldown() == null ^ this.getDefaultCooldown() == null) {
            return false;
        }
        if (other.getDefaultCooldown() != null && !other.getDefaultCooldown().equals(this.getDefaultCooldown())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !((Object)other.getAvailabilityZones()).equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getLoadBalancerNames() == null ^ this.getLoadBalancerNames() == null) {
            return false;
        }
        if (other.getLoadBalancerNames() != null && !((Object)other.getLoadBalancerNames()).equals(this.getLoadBalancerNames())) {
            return false;
        }
        if (other.getHealthCheckType() == null ^ this.getHealthCheckType() == null) {
            return false;
        }
        if (other.getHealthCheckType() != null && !other.getHealthCheckType().equals(this.getHealthCheckType())) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() == null ^ this.getHealthCheckGracePeriod() == null) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() != null && !other.getHealthCheckGracePeriod().equals(this.getHealthCheckGracePeriod())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !((Object)other.getInstances()).equals(this.getInstances())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getSuspendedProcesses() == null ^ this.getSuspendedProcesses() == null) {
            return false;
        }
        if (other.getSuspendedProcesses() != null && !((Object)other.getSuspendedProcesses()).equals(this.getSuspendedProcesses())) {
            return false;
        }
        if (other.getPlacementGroup() == null ^ this.getPlacementGroup() == null) {
            return false;
        }
        if (other.getPlacementGroup() != null && !other.getPlacementGroup().equals(this.getPlacementGroup())) {
            return false;
        }
        if (other.getVPCZoneIdentifier() == null ^ this.getVPCZoneIdentifier() == null) {
            return false;
        }
        if (other.getVPCZoneIdentifier() != null && !other.getVPCZoneIdentifier().equals(this.getVPCZoneIdentifier())) {
            return false;
        }
        if (other.getEnabledMetrics() == null ^ this.getEnabledMetrics() == null) {
            return false;
        }
        if (other.getEnabledMetrics() != null && !((Object)other.getEnabledMetrics()).equals(this.getEnabledMetrics())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }
}

