/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    @Override
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        DefaultRequest<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "AmazonSNS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        if (addPermissionRequest != null && addPermissionRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(addPermissionRequest.getTopicArn()));
        }
        if (addPermissionRequest != null && addPermissionRequest.getLabel() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.getLabel()));
        }
        if (addPermissionRequest != null) {
            List<String> aWSAccountIdsList = addPermissionRequest.getAWSAccountIds();
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringUtils.fromString(aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (addPermissionRequest != null) {
            List<String> actionNamesList = addPermissionRequest.getActionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionName.member." + actionNamesListIndex, StringUtils.fromString(actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        return request;
    }
}

