/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    @Override
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        InstanceMonitoring instanceMonitoring;
        DefaultRequest<CreateLaunchConfigurationRequest> request = new DefaultRequest<CreateLaunchConfigurationRequest>(createLaunchConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString(createLaunchConfigurationRequest.getLaunchConfigurationName()));
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(createLaunchConfigurationRequest.getImageId()));
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(createLaunchConfigurationRequest.getKeyName()));
        }
        if (createLaunchConfigurationRequest != null) {
            List<String> securityGroupsList = createLaunchConfigurationRequest.getSecurityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString(securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString(createLaunchConfigurationRequest.getUserData()));
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(createLaunchConfigurationRequest.getInstanceType()));
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(createLaunchConfigurationRequest.getKernelId()));
        }
        if (createLaunchConfigurationRequest != null && createLaunchConfigurationRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(createLaunchConfigurationRequest.getRamdiskId()));
        }
        if (createLaunchConfigurationRequest != null) {
            List<BlockDeviceMapping> blockDeviceMappingsList = createLaunchConfigurationRequest.getBlockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                if (blockDeviceMappingsListValue != null && blockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(blockDeviceMappingsListValue.getVirtualName()));
                }
                if (blockDeviceMappingsListValue != null && blockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(blockDeviceMappingsListValue.getDeviceName()));
                }
                if (blockDeviceMappingsListValue != null) {
                    Ebs ebs = blockDeviceMappingsListValue.getEbs();
                    if (ebs != null && ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs != null && ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (createLaunchConfigurationRequest != null && (instanceMonitoring = createLaunchConfigurationRequest.getInstanceMonitoring()) != null && instanceMonitoring.isEnabled() != null) {
            request.addParameter("InstanceMonitoring.Enabled", StringUtils.fromBoolean(instanceMonitoring.isEnabled()));
        }
        return request;
    }
}

