/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsync;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingAsyncClient
extends AmazonAutoScalingClient
implements AmazonAutoScalingAsync {
    private ExecutorService executorService;

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(final DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingGroupsResult>(){

            @Override
            public DescribeAutoScalingGroupsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingGroups(describeAutoScalingGroupsRequest);
            }
        });
    }

    @Override
    public Future<Void> enableMetricsCollectionAsync(final EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.enableMetricsCollection(enableMetricsCollectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resumeProcessesAsync(final ResumeProcessesRequest resumeProcessesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.resumeProcesses(resumeProcessesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(final DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteLaunchConfiguration(deleteLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(final DescribePoliciesRequest describePoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePoliciesResult>(){

            @Override
            public DescribePoliciesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describePolicies(describePoliciesRequest);
            }
        });
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(final DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingProcessTypesResult>(){

            @Override
            public DescribeScalingProcessTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScalingProcessTypes(describeScalingProcessTypesRequest);
            }
        });
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(final CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createAutoScalingGroup(createAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(final DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScalingActivities(describeScalingActivitiesRequest);
            }
        });
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(final DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNotificationConfigurationsResult>(){

            @Override
            public DescribeNotificationConfigurationsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeNotificationConfigurations(describeNotificationConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<Void> executePolicyAsync(final ExecutePolicyRequest executePolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.executePolicy(executePolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(final PutScalingPolicyRequest putScalingPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutScalingPolicyResult>(){

            @Override
            public PutScalingPolicyResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.putScalingPolicy(putScalingPolicyRequest);
            }
        });
    }

    @Override
    public Future<Void> putNotificationConfigurationAsync(final PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.putNotificationConfiguration(putNotificationConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyAsync(final DeletePolicyRequest deletePolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deletePolicy(deletePolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNotificationConfigurationAsync(final DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteNotificationConfiguration(deleteNotificationConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteScheduledActionAsync(final DeleteScheduledActionRequest deleteScheduledActionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteScheduledAction(deleteScheduledActionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setInstanceHealthAsync(final SetInstanceHealthRequest setInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.setInstanceHealth(setInstanceHealthRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(final DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingNotificationTypesResult>(){

            @Override
            public DescribeAutoScalingNotificationTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingNotificationTypes(describeAutoScalingNotificationTypesRequest);
            }
        });
    }

    @Override
    public Future<Void> suspendProcessesAsync(final SuspendProcessesRequest suspendProcessesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.suspendProcesses(suspendProcessesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(final DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingInstancesResult>(){

            @Override
            public DescribeAutoScalingInstancesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingInstances(describeAutoScalingInstancesRequest);
            }
        });
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(final CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createLaunchConfiguration(createLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(final DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteAutoScalingGroup(deleteAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableMetricsCollectionAsync(final DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.disableMetricsCollection(disableMetricsCollectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(final UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.updateAutoScalingGroup(updateAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(final DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationsResult>(){

            @Override
            public DescribeLaunchConfigurationsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeLaunchConfigurations(describeLaunchConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(final DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAdjustmentTypesResult>(){

            @Override
            public DescribeAdjustmentTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAdjustmentTypes(describeAdjustmentTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(final DescribeScheduledActionsRequest describeScheduledActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScheduledActionsResult>(){

            @Override
            public DescribeScheduledActionsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScheduledActions(describeScheduledActionsRequest);
            }
        });
    }

    @Override
    public Future<Void> putScheduledUpdateGroupActionAsync(final PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.putScheduledUpdateGroupAction(putScheduledUpdateGroupActionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(final DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricCollectionTypesResult>(){

            @Override
            public DescribeMetricCollectionTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeMetricCollectionTypes(describeMetricCollectionTypesRequest);
            }
        });
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(final SetDesiredCapacityRequest setDesiredCapacityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.setDesiredCapacity(setDesiredCapacityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(final TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstanceInAutoScalingGroupResult>(){

            @Override
            public TerminateInstanceInAutoScalingGroupResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.terminateInstanceInAutoScalingGroup(terminateInstanceInAutoScalingGroupRequest);
            }
        });
    }
}

