/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutePolicyRequestMarshaller
implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {
    @Override
    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {
        DefaultRequest<ExecutePolicyRequest> request = new DefaultRequest<ExecutePolicyRequest>(executePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        if (executePolicyRequest != null && executePolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(executePolicyRequest.getAutoScalingGroupName()));
        }
        if (executePolicyRequest != null && executePolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(executePolicyRequest.getPolicyName()));
        }
        if (executePolicyRequest != null && executePolicyRequest.isHonorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean(executePolicyRequest.isHonorCooldown()));
        }
        return request;
    }
}

