/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Region {
    US_Standard(null),
    US_West("us-west-1"),
    US_West_2("us-west-2"),
    EU_Ireland("EU"),
    AP_Singapore("ap-southeast-1"),
    AP_Tokyo("ap-northeast-1");

    private final String regionId;

    private Region(String regionId) {
        this.regionId = regionId;
    }

    public String toString() {
        return this.regionId;
    }

    public static Region fromValue(String s3RegionString) throws IllegalArgumentException {
        for (Region region : Region.values()) {
            String regionString = region.toString();
            if (regionString == null && s3RegionString == null) {
                return region;
            }
            if (regionString == null || !regionString.equals(s3RegionString)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + s3RegionString + " value!");
    }
}

