/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFlowInstancesConfig {
    private String masterInstanceType;
    private String slaveInstanceType;
    private Integer instanceCount;
    private List<InstanceGroupConfig> instanceGroups;
    private String ec2KeyName;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public JobFlowInstancesConfig withMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
        return this;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public JobFlowInstancesConfig withSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public JobFlowInstancesConfig withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ArrayList<InstanceGroupConfig>();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
    }

    public JobFlowInstancesConfig withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupConfig>());
        }
        for (InstanceGroupConfig value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public JobFlowInstancesConfig withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
        return this;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public JobFlowInstancesConfig withEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
        return this;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public JobFlowInstancesConfig withPlacement(PlacementType placement) {
        this.placement = placement;
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesConfig withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        return this;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public JobFlowInstancesConfig withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public JobFlowInstancesConfig withHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("MasterInstanceType: " + this.masterInstanceType + ", ");
        sb.append("SlaveInstanceType: " + this.slaveInstanceType + ", ");
        sb.append("InstanceCount: " + this.instanceCount + ", ");
        sb.append("InstanceGroups: " + this.instanceGroups + ", ");
        sb.append("Ec2KeyName: " + this.ec2KeyName + ", ");
        sb.append("Placement: " + this.placement + ", ");
        sb.append("KeepJobFlowAliveWhenNoSteps: " + this.keepJobFlowAliveWhenNoSteps + ", ");
        sb.append("TerminationProtected: " + this.terminationProtected + ", ");
        sb.append("HadoopVersion: " + this.hadoopVersion + ", ");
        sb.append("}");
        return sb.toString();
    }
}

