/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemail.model.RawMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendRawEmailRequest
extends AmazonWebServiceRequest {
    private String source;
    private List<String> destinations;
    private RawMessage rawMessage;

    public SendRawEmailRequest() {
    }

    public SendRawEmailRequest(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SendRawEmailRequest withSource(String source) {
        this.source = source;
        return this;
    }

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new ArrayList<String>();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        ArrayList<String> destinationsCopy = new ArrayList<String>();
        if (destinations != null) {
            destinationsCopy.addAll(destinations);
        }
        this.destinations = destinationsCopy;
    }

    public SendRawEmailRequest withDestinations(String ... destinations) {
        if (this.getDestinations() == null) {
            this.setDestinations(new ArrayList<String>());
        }
        for (String value : destinations) {
            this.getDestinations().add(value);
        }
        return this;
    }

    public SendRawEmailRequest withDestinations(Collection<String> destinations) {
        ArrayList<String> destinationsCopy = new ArrayList<String>();
        if (destinations != null) {
            destinationsCopy.addAll(destinations);
        }
        this.destinations = destinationsCopy;
        return this;
    }

    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public SendRawEmailRequest withRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Source: " + this.source + ", ");
        sb.append("Destinations: " + this.destinations + ", ");
        sb.append("RawMessage: " + this.rawMessage + ", ");
        sb.append("}");
        return sb.toString();
    }
}

