/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateEnvironmentRequest
extends AmazonWebServiceRequest {
    private String applicationName;
    private String versionLabel;
    private String environmentName;
    private String templateName;
    private String solutionStackName;
    private String cNAMEPrefix;
    private String description;
    private List<ConfigurationOptionSetting> optionSettings;
    private List<OptionSpecification> optionsToRemove;

    public CreateEnvironmentRequest() {
    }

    public CreateEnvironmentRequest(String applicationName, String environmentName) {
        this.applicationName = applicationName;
        this.environmentName = environmentName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public CreateEnvironmentRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public CreateEnvironmentRequest withVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
        return this;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public CreateEnvironmentRequest withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public CreateEnvironmentRequest withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public CreateEnvironmentRequest withSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
        return this;
    }

    public String getCNAMEPrefix() {
        return this.cNAMEPrefix;
    }

    public void setCNAMEPrefix(String cNAMEPrefix) {
        this.cNAMEPrefix = cNAMEPrefix;
    }

    public CreateEnvironmentRequest withCNAMEPrefix(String cNAMEPrefix) {
        this.cNAMEPrefix = cNAMEPrefix;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateEnvironmentRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
    }

    public CreateEnvironmentRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<ConfigurationOptionSetting>());
        }
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public CreateEnvironmentRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new ArrayList<OptionSpecification>();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>();
        if (optionsToRemove != null) {
            optionsToRemoveCopy.addAll(optionsToRemove);
        }
        this.optionsToRemove = optionsToRemoveCopy;
    }

    public CreateEnvironmentRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.getOptionsToRemove() == null) {
            this.setOptionsToRemove(new ArrayList<OptionSpecification>());
        }
        for (OptionSpecification value : optionsToRemove) {
            this.getOptionsToRemove().add(value);
        }
        return this;
    }

    public CreateEnvironmentRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>();
        if (optionsToRemove != null) {
            optionsToRemoveCopy.addAll(optionsToRemove);
        }
        this.optionsToRemove = optionsToRemoveCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ApplicationName: " + this.applicationName + ", ");
        sb.append("VersionLabel: " + this.versionLabel + ", ");
        sb.append("EnvironmentName: " + this.environmentName + ", ");
        sb.append("TemplateName: " + this.templateName + ", ");
        sb.append("SolutionStackName: " + this.solutionStackName + ", ");
        sb.append("CNAMEPrefix: " + this.cNAMEPrefix + ", ");
        sb.append("Description: " + this.description + ", ");
        sb.append("OptionSettings: " + this.optionSettings + ", ");
        sb.append("OptionsToRemove: " + this.optionsToRemove + ", ");
        sb.append("}");
        return sb.toString();
    }
}

