/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPolicyWriter {
    public String writePolicyToString(Policy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Policy cannot be null");
        }
        StringWriter writer = new StringWriter();
        try {
            JSONWriter generator = new JSONWriter(writer);
            this.writePolicy(policy, generator);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            String message = "Unable to serialize policy to JSON string: " + e.getMessage();
            throw new IllegalArgumentException(message, e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    private void writePolicy(Policy policy, JSONWriter generator) throws JSONException, IOException {
        generator.object();
        generator.key("Version").value(policy.getVersion());
        if (policy.getId() != null) {
            generator.key("Id").value(policy.getId());
        }
        generator.key("Statement").array();
        for (Statement statement : policy.getStatements()) {
            generator.object();
            if (statement.getId() != null) {
                generator.key("Sid").value(statement.getId());
            }
            generator.key("Effect").value(statement.getEffect().toString());
            this.writePrincipals(statement, generator);
            this.writeActions(statement, generator);
            this.writeResources(statement, generator);
            this.writeConditions(statement, generator);
            generator.endObject();
        }
        generator.endArray();
        generator.endObject();
    }

    private void writeConditions(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Condition> conditions = statement.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return;
        }
        Map<String, List<Condition>> conditionsByType = this.sortConditionsByType(conditions);
        generator.key("Condition").object();
        for (String conditionType : conditionsByType.keySet()) {
            generator.key(conditionType).object();
            Map<String, List<String>> conditionValuesByKey = this.sortConditionsByKey(conditionsByType.get(conditionType));
            for (String conditionKey : conditionValuesByKey.keySet()) {
                generator.key(conditionKey).array();
                for (String value : conditionValuesByKey.get(conditionKey)) {
                    generator.value(value);
                }
                generator.endArray();
            }
            generator.endObject();
        }
        generator.endObject();
    }

    private Map<String, List<String>> sortConditionsByKey(List<Condition> conditions) {
        HashMap<String, List<String>> conditionValuesByConditionKey = new HashMap<String, List<String>>();
        for (Condition condition : conditions) {
            String key = condition.getConditionKey();
            List<String> values = condition.getValues();
            if (!conditionValuesByConditionKey.containsKey(key)) {
                conditionValuesByConditionKey.put(key, new ArrayList());
            }
            ((List)conditionValuesByConditionKey.get(key)).addAll(values);
        }
        return conditionValuesByConditionKey;
    }

    private Map<String, List<Condition>> sortConditionsByType(List<Condition> conditions) {
        HashMap<String, List<Condition>> conditionsByType = new HashMap<String, List<Condition>>();
        for (Condition condition : conditions) {
            String conditionType = condition.getType();
            if (conditionsByType.get(conditionType) == null) {
                conditionsByType.put(conditionType, new ArrayList());
            }
            ((List)conditionsByType.get(conditionType)).add(condition);
        }
        return conditionsByType;
    }

    private void writeResources(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Resource> resources = statement.getResources();
        if (resources == null || resources.isEmpty()) {
            return;
        }
        generator.key("Resource").array();
        for (Resource resource : resources) {
            generator.value(resource.getId());
        }
        generator.endArray();
    }

    private void writeActions(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Action> actions = statement.getActions();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        generator.key("Action").array();
        for (Action action : actions) {
            generator.value(action.getActionName());
        }
        generator.endArray();
    }

    private void writePrincipals(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Principal> principals = statement.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return;
        }
        generator.key("Principal").object();
        HashMap<String, ArrayList<String>> principalIdsByScheme = new HashMap<String, ArrayList<String>>();
        for (Principal p : principals) {
            ArrayList<String> principalIds = (ArrayList<String>)principalIdsByScheme.get(p.getProvider());
            if (principalIds == null) {
                principalIds = new ArrayList<String>();
                principalIdsByScheme.put(p.getProvider(), principalIds);
            }
            principalIds.add(p.getId());
        }
        for (String scheme : principalIdsByScheme.keySet()) {
            generator.key(scheme).array();
            for (String principalId : (List)principalIdsByScheme.get(scheme)) {
                generator.value(principalId);
            }
            generator.endArray();
        }
        generator.endObject();
    }
}

