/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.importexport.AmazonImportExport;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import com.amazonaws.services.importexport.model.transform.BucketPermissionExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CanceledJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ExpiredJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAccessKeyIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAddressExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidFileSystemExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MalformedManifestExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MultipleRegionsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.NoSuchBucketExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UnableToCancelJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonImportExportClient
extends AmazonWebServiceClient
implements AmazonImportExport {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    private final List<RequestHandler> requestHandlers;
    private QueryStringSigner signer;

    public AmazonImportExportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonImportExportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new BucketPermissionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidFileSystemExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ExpiredJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedManifestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAddressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MultipleRegionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnableToCancelJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CanceledJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchBucketExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAccessKeyIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("importexport.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/importexport/request.handlers"));
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateJobRequest> request = new CreateJobRequestMarshaller().marshall(createJobRequest);
        return this.invoke(request, new CreateJobResultStaxUnmarshaller());
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) throws AmazonServiceException, AmazonClientException {
        Request<CancelJobRequest> request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
        return this.invoke(request, new CancelJobResultStaxUnmarshaller());
    }

    @Override
    public GetStatusResult getStatus(GetStatusRequest getStatusRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetStatusRequest> request = new GetStatusRequestMarshaller().marshall(getStatusRequest);
        return this.invoke(request, new GetStatusResultStaxUnmarshaller());
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListJobsRequest> request = new ListJobsRequestMarshaller().marshall(listJobsRequest);
        return this.invoke(request, new ListJobsResultStaxUnmarshaller());
    }

    @Override
    public UpdateJobResult updateJob(UpdateJobRequest updateJobRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateJobRequest> request = new UpdateJobRequestMarshaller().marshall(updateJobRequest);
        return this.invoke(request, new UpdateJobResultStaxUnmarshaller());
    }

    @Override
    public ListJobsResult listJobs() throws AmazonServiceException, AmazonClientException {
        return this.listJobs(new ListJobsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

