/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeRouteTablesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeRouteTablesRequestMarshaller
implements Marshaller<Request<DescribeRouteTablesRequest>, DescribeRouteTablesRequest> {
    @Override
    public Request<DescribeRouteTablesRequest> marshall(DescribeRouteTablesRequest describeRouteTablesRequest) {
        DefaultRequest<DescribeRouteTablesRequest> request = new DefaultRequest<DescribeRouteTablesRequest>(describeRouteTablesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeRouteTables");
        request.addParameter("Version", "2011-01-01");
        if (describeRouteTablesRequest != null) {
            List<String> routeTableIdsList = describeRouteTablesRequest.getRouteTableIds();
            int routeTableIdsListIndex = 1;
            for (String routeTableIdsListValue : routeTableIdsList) {
                if (routeTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString(routeTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (describeRouteTablesRequest != null) {
            List<Filter> filtersList = describeRouteTablesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null && filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (filtersListValue != null) {
                    List<String> valuesList = filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

