/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesResult;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.CreateAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.CreateLaunchConfigurationRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteLaunchConfigurationRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeletePolicyRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteScheduledActionRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAdjustmentTypesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAdjustmentTypesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingInstancesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingInstancesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeMetricCollectionTypesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeMetricCollectionTypesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribePoliciesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribePoliciesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingProcessTypesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingProcessTypesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScheduledActionsRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScheduledActionsResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DisableMetricsCollectionRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.EnableMetricsCollectionRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.ExecutePolicyRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.PutScalingPolicyRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.PutScalingPolicyResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.ResumeProcessesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.ScalingActivityInProgressExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.SetDesiredCapacityRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.SetInstanceHealthRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.SuspendProcessesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.UpdateAutoScalingGroupRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingClient
extends AmazonWebServiceClient
implements AmazonAutoScaling {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private final List<RequestHandler> requestHandlers;
    private QueryStringSigner signer;

    public AmazonAutoScalingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonAutoScalingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ScalingActivityInProgressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("autoscaling.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/autoscaling/request.handlers"));
        this.client = new HttpClient(clientConfiguration);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public void putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutScheduledUpdateGroupActionRequest> request = new PutScheduledUpdateGroupActionRequestMarshaller().marshall(putScheduledUpdateGroupActionRequest);
        this.invoke(request, null);
    }

    @Override
    public void setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetDesiredCapacityRequest> request = new SetDesiredCapacityRequestMarshaller().marshall(setDesiredCapacityRequest);
        this.invoke(request, null);
    }

    @Override
    public void deletePolicy(DeletePolicyRequest deletePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeletePolicyRequest> request = new DeletePolicyRequestMarshaller().marshall(deletePolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteScheduledActionRequest> request = new DeleteScheduledActionRequestMarshaller().marshall(deleteScheduledActionRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeLaunchConfigurationsRequest> request = new DescribeLaunchConfigurationsRequestMarshaller().marshall(describeLaunchConfigurationsRequest);
        return this.invoke(request, new DescribeLaunchConfigurationsResultStaxUnmarshaller());
    }

    @Override
    public DescribeScalingProcessTypesResult describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeScalingProcessTypesRequest> request = new DescribeScalingProcessTypesRequestMarshaller().marshall(describeScalingProcessTypesRequest);
        return this.invoke(request, new DescribeScalingProcessTypesResultStaxUnmarshaller());
    }

    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAutoScalingGroupsRequest> request = new DescribeAutoScalingGroupsRequestMarshaller().marshall(describeAutoScalingGroupsRequest);
        return this.invoke(request, new DescribeAutoScalingGroupsResultStaxUnmarshaller());
    }

    @Override
    public void enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableMetricsCollectionRequest> request = new EnableMetricsCollectionRequestMarshaller().marshall(enableMetricsCollectionRequest);
        this.invoke(request, null);
    }

    @Override
    public TerminateInstanceInAutoScalingGroupResult terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateInstanceInAutoScalingGroupRequest> request = new TerminateInstanceInAutoScalingGroupRequestMarshaller().marshall(terminateInstanceInAutoScalingGroupRequest);
        return this.invoke(request, new TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller());
    }

    @Override
    public DescribeScalingActivitiesResult describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeScalingActivitiesRequest> request = new DescribeScalingActivitiesRequestMarshaller().marshall(describeScalingActivitiesRequest);
        return this.invoke(request, new DescribeScalingActivitiesResultStaxUnmarshaller());
    }

    @Override
    public void executePolicy(ExecutePolicyRequest executePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<ExecutePolicyRequest> request = new ExecutePolicyRequestMarshaller().marshall(executePolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeMetricCollectionTypesResult describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeMetricCollectionTypesRequest> request = new DescribeMetricCollectionTypesRequestMarshaller().marshall(describeMetricCollectionTypesRequest);
        return this.invoke(request, new DescribeMetricCollectionTypesResultStaxUnmarshaller());
    }

    @Override
    public DescribePoliciesResult describePolicies(DescribePoliciesRequest describePoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribePoliciesRequest> request = new DescribePoliciesRequestMarshaller().marshall(describePoliciesRequest);
        return this.invoke(request, new DescribePoliciesResultStaxUnmarshaller());
    }

    @Override
    public DescribeAdjustmentTypesResult describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAdjustmentTypesRequest> request = new DescribeAdjustmentTypesRequestMarshaller().marshall(describeAdjustmentTypesRequest);
        return this.invoke(request, new DescribeAdjustmentTypesResultStaxUnmarshaller());
    }

    @Override
    public void deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAutoScalingGroupRequest> request = new DeleteAutoScalingGroupRequestMarshaller().marshall(deleteAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAutoScalingGroupRequest> request = new CreateAutoScalingGroupRequestMarshaller().marshall(createAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeAutoScalingInstancesResult describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAutoScalingInstancesRequest> request = new DescribeAutoScalingInstancesRequestMarshaller().marshall(describeAutoScalingInstancesRequest);
        return this.invoke(request, new DescribeAutoScalingInstancesResultStaxUnmarshaller());
    }

    @Override
    public void deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLaunchConfigurationRequest> request = new DeleteLaunchConfigurationRequestMarshaller().marshall(deleteLaunchConfigurationRequest);
        this.invoke(request, null);
    }

    @Override
    public PutScalingPolicyResult putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutScalingPolicyRequest> request = new PutScalingPolicyRequestMarshaller().marshall(putScalingPolicyRequest);
        return this.invoke(request, new PutScalingPolicyResultStaxUnmarshaller());
    }

    @Override
    public void setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetInstanceHealthRequest> request = new SetInstanceHealthRequestMarshaller().marshall(setInstanceHealthRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAutoScalingGroupRequest> request = new UpdateAutoScalingGroupRequestMarshaller().marshall(updateAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeScheduledActionsResult describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeScheduledActionsRequest> request = new DescribeScheduledActionsRequestMarshaller().marshall(describeScheduledActionsRequest);
        return this.invoke(request, new DescribeScheduledActionsResultStaxUnmarshaller());
    }

    @Override
    public void suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) throws AmazonServiceException, AmazonClientException {
        Request<SuspendProcessesRequest> request = new SuspendProcessesRequestMarshaller().marshall(suspendProcessesRequest);
        this.invoke(request, null);
    }

    @Override
    public void resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResumeProcessesRequest> request = new ResumeProcessesRequestMarshaller().marshall(resumeProcessesRequest);
        this.invoke(request, null);
    }

    @Override
    public void createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLaunchConfigurationRequest> request = new CreateLaunchConfigurationRequestMarshaller().marshall(createLaunchConfigurationRequest);
        this.invoke(request, null);
    }

    @Override
    public void disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DisableMetricsCollectionRequest> request = new DisableMetricsCollectionRequestMarshaller().marshall(disableMetricsCollectionRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations() throws AmazonServiceException, AmazonClientException {
        return this.describeLaunchConfigurations(new DescribeLaunchConfigurationsRequest());
    }

    @Override
    public DescribeScalingProcessTypesResult describeScalingProcessTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeScalingProcessTypes(new DescribeScalingProcessTypesRequest());
    }

    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
    }

    @Override
    public DescribeScalingActivitiesResult describeScalingActivities() throws AmazonServiceException, AmazonClientException {
        return this.describeScalingActivities(new DescribeScalingActivitiesRequest());
    }

    @Override
    public DescribeMetricCollectionTypesResult describeMetricCollectionTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeMetricCollectionTypes(new DescribeMetricCollectionTypesRequest());
    }

    @Override
    public DescribePoliciesResult describePolicies() throws AmazonServiceException, AmazonClientException {
        return this.describePolicies(new DescribePoliciesRequest());
    }

    @Override
    public DescribeAdjustmentTypesResult describeAdjustmentTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeAdjustmentTypes(new DescribeAdjustmentTypesRequest());
    }

    @Override
    public DescribeAutoScalingInstancesResult describeAutoScalingInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest());
    }

    @Override
    public DescribeScheduledActionsResult describeScheduledActions() throws AmazonServiceException, AmazonClientException {
        return this.describeScheduledActions(new DescribeScheduledActionsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

