/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SignatureVersion;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import java.net.URI;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringSigner
extends AbstractAWSSigner
implements Signer {
    private final AWSCredentials credentials;

    public QueryStringSigner(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public void sign(Request<?> request) throws SignatureException {
        this.sign(request, SignatureVersion.V2, SigningAlgorithm.HmacSHA256);
    }

    @Override
    public void sign(Request<?> request, SignatureVersion version, SigningAlgorithm algorithm) throws SignatureException {
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(this.credentials);
        request.addParameter("AWSAccessKeyId", sanitizedCredentials.getAWSAccessKeyId());
        request.addParameter("SignatureVersion", version.toString());
        request.addParameter("Timestamp", this.getFormattedTimestamp());
        String stringToSign = null;
        if (version.equals((Object)SignatureVersion.V1)) {
            stringToSign = this.calculateStringToSignV1(request.getParameters());
        } else if (version.equals((Object)SignatureVersion.V2)) {
            request.addParameter("SignatureMethod", algorithm.toString());
            stringToSign = this.calculateStringToSignV2(request.getEndpoint(), request.getParameters());
        } else {
            throw new SignatureException("Invalid Signature Version specified");
        }
        String signatureValue = this.sign(stringToSign, sanitizedCredentials.getAWSSecretKey(), algorithm);
        request.addParameter("Signature", signatureValue);
    }

    private String calculateStringToSignV1(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (String key : sorted.keySet()) {
            data.append(key);
            data.append((String)sorted.get(key));
        }
        return data.toString();
    }

    private String calculateStringToSignV2(URI endpoint, Map<String, String> parameters) throws SignatureException {
        StringBuilder data = new StringBuilder();
        data.append("POST").append("\n");
        data.append(this.getCanonicalizedEndpoint(endpoint)).append("\n");
        data.append(this.getCanonicalizedResourcePath(endpoint)).append("\n");
        data.append(this.getCanonicalizedQueryString(parameters));
        return data.toString();
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }
}

