/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminateInstancesRequestMarshaller
implements Marshaller<Request<TerminateInstancesRequest>, TerminateInstancesRequest> {
    @Override
    public Request<TerminateInstancesRequest> marshall(TerminateInstancesRequest terminateInstancesRequest) {
        DefaultRequest<TerminateInstancesRequest> request = new DefaultRequest<TerminateInstancesRequest>(terminateInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "TerminateInstances");
        request.addParameter("Version", "2010-08-31");
        if (terminateInstancesRequest != null) {
            List<String> instanceIdsList = terminateInstancesRequest.getInstanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

