/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    @Override
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        DefaultRequest<CreateLoadBalancerRequest> request = new DefaultRequest<CreateLoadBalancerRequest>(createLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2010-07-01");
        if (createLoadBalancerRequest != null && createLoadBalancerRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(createLoadBalancerRequest.getLoadBalancerName()));
        }
        if (createLoadBalancerRequest != null) {
            List<Listener> listenersList = createLoadBalancerRequest.getListeners();
            int listenersListIndex = 1;
            for (Listener listenersListValue : listenersList) {
                if (listenersListValue != null && listenersListValue.getProtocol() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".Protocol", StringUtils.fromString(listenersListValue.getProtocol()));
                }
                if (listenersListValue != null && listenersListValue.getLoadBalancerPort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".LoadBalancerPort", StringUtils.fromInteger(listenersListValue.getLoadBalancerPort()));
                }
                if (listenersListValue != null && listenersListValue.getInstancePort() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".InstancePort", StringUtils.fromInteger(listenersListValue.getInstancePort()));
                }
                if (listenersListValue != null && listenersListValue.getSSLCertificateId() != null) {
                    request.addParameter("Listeners.member." + listenersListIndex + ".SSLCertificateId", StringUtils.fromString(listenersListValue.getSSLCertificateId()));
                }
                ++listenersListIndex;
            }
        }
        if (createLoadBalancerRequest != null) {
            List<String> availabilityZonesList = createLoadBalancerRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString(availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        return request;
    }
}

