/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import java.io.File;

public class UploadPartRequestFactory {
    private int partNumber = 1;
    private final String bucketName;
    private final String key;
    private final String uploadId;
    private final long optimalPartSize;
    private final File file;
    private int offset = 0;
    private long remainingBytes;
    private final PutObjectRequest putObjectRequest;

    public UploadPartRequestFactory(PutObjectRequest putObjectRequest, String uploadId, long optimalPartSize) {
        this.putObjectRequest = putObjectRequest;
        this.uploadId = uploadId;
        this.optimalPartSize = optimalPartSize;
        this.bucketName = putObjectRequest.getBucketName();
        this.key = putObjectRequest.getKey();
        this.file = TransferManagerUtils.getRequestFile(putObjectRequest);
        this.remainingBytes = TransferManagerUtils.getContentLength(putObjectRequest);
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized UploadPartRequest getNextUploadPartRequest() {
        long partSize = Math.min(this.optimalPartSize, this.remainingBytes);
        UploadPartRequest request = null;
        request = this.putObjectRequest.getInputStream() != null ? new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream(new InputSubstream(this.putObjectRequest.getInputStream(), 0L, partSize)).withPartNumber(this.partNumber++).withPartSize(partSize) : new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withFile(this.file).withFileOffset(this.offset).withPartNumber(this.partNumber++).withPartSize(partSize);
        request.setProgressListener(this.putObjectRequest.getProgressListener());
        this.offset = (int)((long)this.offset + partSize);
        this.remainingBytes -= partSize;
        return request;
    }
}

