/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.ProgressListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ProgressListenerChain
implements ProgressListener {
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private final ExecutorService executor;

    public ProgressListenerChain(ExecutorService executor, ProgressListener ... listeners) {
        this.executor = executor;
        for (ProgressListener listener : listeners) {
            this.addProgressListener(listener);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void progressChanged(final ProgressEvent progressEvent) {
        this.executor.submit(new Runnable(){

            public void run() {
                for (ProgressListener listener : ProgressListenerChain.this.listeners) {
                    try {
                        listener.progressChanged(progressEvent);
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }
}

