/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ResponseMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseMetadataCache {
    private final int maxEntries;
    private Map<Object, ResponseMetadata> map;
    private List<Object> objectList;

    public ResponseMetadataCache(int maxEntries) {
        this.maxEntries = maxEntries;
        this.objectList = new ArrayList<Object>(maxEntries);
        this.map = new HashMap<Object, ResponseMetadata>();
    }

    public synchronized void add(Object obj, ResponseMetadata metadata) {
        if (obj == null) {
            return;
        }
        if (this.map.size() >= this.maxEntries) {
            this.evictOldest();
        }
        this.store(obj, metadata);
    }

    public ResponseMetadata get(Object obj) {
        return this.map.get(obj);
    }

    private void evictOldest() {
        this.map.remove(this.objectList.remove(0));
    }

    private void store(Object obj, ResponseMetadata metadata) {
        this.map.put(obj, metadata);
        this.objectList.add(obj);
    }
}

