/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceLicenseSpecification;
import com.amazonaws.services.ec2.model.Placement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunInstancesRequest
extends AmazonWebServiceRequest {
    private String imageId;
    private Integer minCount;
    private Integer maxCount;
    private String keyName;
    private List<String> securityGroups;
    private String userData;
    private String instanceType;
    private Placement placement;
    private String kernelId;
    private String ramdiskId;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private Boolean monitoring;
    private String subnetId;
    private Boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private InstanceLicenseSpecification license;
    private String privateIpAddress;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public RunInstancesRequest withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public Integer getMinCount() {
        return this.minCount;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public RunInstancesRequest withMinCount(Integer minCount) {
        this.minCount = minCount;
        return this;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public RunInstancesRequest withMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public RunInstancesRequest withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
    }

    public RunInstancesRequest withSecurityGroups(String ... securityGroups) {
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public RunInstancesRequest withSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public RunInstancesRequest withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public RunInstancesRequest withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public RunInstancesRequest withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public RunInstancesRequest withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public RunInstancesRequest withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public RunInstancesRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public RunInstancesRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
        return this;
    }

    public Boolean isMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public RunInstancesRequest withMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
        return this;
    }

    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public RunInstancesRequest withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public RunInstancesRequest withDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
        return this;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public RunInstancesRequest withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        return this;
    }

    public InstanceLicenseSpecification getLicense() {
        return this.license;
    }

    public void setLicense(InstanceLicenseSpecification license) {
        this.license = license;
    }

    public RunInstancesRequest withLicense(InstanceLicenseSpecification license) {
        this.license = license;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public RunInstancesRequest withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ImageId: " + this.imageId + ", ");
        sb.append("MinCount: " + this.minCount + ", ");
        sb.append("MaxCount: " + this.maxCount + ", ");
        sb.append("KeyName: " + this.keyName + ", ");
        sb.append("SecurityGroups: " + this.securityGroups + ", ");
        sb.append("UserData: " + this.userData + ", ");
        sb.append("InstanceType: " + this.instanceType + ", ");
        sb.append("Placement: " + this.placement + ", ");
        sb.append("KernelId: " + this.kernelId + ", ");
        sb.append("RamdiskId: " + this.ramdiskId + ", ");
        sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        sb.append("Monitoring: " + this.monitoring + ", ");
        sb.append("SubnetId: " + this.subnetId + ", ");
        sb.append("DisableApiTermination: " + this.disableApiTermination + ", ");
        sb.append("InstanceInitiatedShutdownBehavior: " + this.instanceInitiatedShutdownBehavior + ", ");
        sb.append("License: " + this.license + ", ");
        sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        sb.append("}");
        return sb.toString();
    }
}

