/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractS3ResponseHandler<T>
implements HttpResponseHandler<ResponseMetadata<T>> {
    private static final Log log = LogFactory.getLog(S3MetadataResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected ResponseMetadata<T> parseResponseMetadata(HttpResponse response) {
        ResponseMetadata responseMetadata = new ResponseMetadata();
        String awsRequestId = response.getHeaders().get("x-amz-request-id");
        responseMetadata.setRequestId(awsRequestId);
        String id2 = response.getHeaders().get("x-amz-id-2");
        return responseMetadata;
    }

    protected void populateObjectMetadata(HttpResponse response, ObjectMetadata metadata) {
        for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
            String key = header.getKey();
            if (key.startsWith("x-amz-meta-")) {
                key = key.substring("x-amz-meta-".length());
                metadata.addUserMetadata(key, header.getValue());
                continue;
            }
            if (ignoredHeaders.contains(key)) continue;
            if (key.equals("Last-Modified")) {
                try {
                    metadata.setHeader(key, ServiceUtils.parseRfc822Date(header.getValue()));
                }
                catch (ParseException pe) {
                    log.warn((Object)("Unable to parse last modified date: " + header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equals("Content-Length")) {
                try {
                    metadata.setHeader(key, Long.parseLong(header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Unable to parse content length: " + header.getValue()), (Throwable)nfe);
                }
                continue;
            }
            if (key.equals("ETag")) {
                metadata.setHeader(key, ServiceUtils.removeQuotes(header.getValue()));
                continue;
            }
            metadata.setHeader(key, header.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
    }
}

