/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.DefaultResponseHandler;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResult;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicateLoadBalancerNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicatePolicyNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidConfigurationRequestExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidInstanceExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.LoadBalancerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerResultUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyLoadBalancersExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyPoliciesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticLoadBalancingClient
extends AmazonWebServiceClient
implements AmazonElasticLoadBalancing {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    private List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new ListenerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicatePolicyNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInstanceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LoadBalancerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidConfigurationRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PolicyNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyPoliciesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyLoadBalancersExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateLoadBalancerNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticloadbalancing.amazonaws.com");
        this.requestHandlers = new HandlerChainFactory().newRequestHandlerChain("/com/amazonaws/services/elasticloadbalancing/request.handlers");
    }

    @Override
    public SetLoadBalancerPoliciesOfListenerResult setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetLoadBalancerPoliciesOfListenerRequest> request = new SetLoadBalancerPoliciesOfListenerRequestMarshaller().marshall(setLoadBalancerPoliciesOfListenerRequest);
        return this.invoke(request, "//SetLoadBalancerPoliciesOfListenerResult", new SetLoadBalancerPoliciesOfListenerResultUnmarshaller());
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeLoadBalancersRequest> request = new DescribeLoadBalancersRequestMarshaller().marshall(describeLoadBalancersRequest);
        return this.invoke(request, "//DescribeLoadBalancersResult", new DescribeLoadBalancersResultUnmarshaller());
    }

    @Override
    public CreateAppCookieStickinessPolicyResult createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAppCookieStickinessPolicyRequest> request = new CreateAppCookieStickinessPolicyRequestMarshaller().marshall(createAppCookieStickinessPolicyRequest);
        return this.invoke(request, "//CreateAppCookieStickinessPolicyResult", new CreateAppCookieStickinessPolicyResultUnmarshaller());
    }

    @Override
    public DisableAvailabilityZonesForLoadBalancerResult disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DisableAvailabilityZonesForLoadBalancerRequest> request = new DisableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(disableAvailabilityZonesForLoadBalancerRequest);
        return this.invoke(request, "//DisableAvailabilityZonesForLoadBalancerResult", new DisableAvailabilityZonesForLoadBalancerResultUnmarshaller());
    }

    @Override
    public DescribeInstanceHealthResult describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeInstanceHealthRequest> request = new DescribeInstanceHealthRequestMarshaller().marshall(describeInstanceHealthRequest);
        return this.invoke(request, "//DescribeInstanceHealthResult", new DescribeInstanceHealthResultUnmarshaller());
    }

    @Override
    public CreateLoadBalancerResult createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLoadBalancerRequest> request = new CreateLoadBalancerRequestMarshaller().marshall(createLoadBalancerRequest);
        return this.invoke(request, "//CreateLoadBalancerResult", new CreateLoadBalancerResultUnmarshaller());
    }

    @Override
    public RegisterInstancesWithLoadBalancerResult registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterInstancesWithLoadBalancerRequest> request = new RegisterInstancesWithLoadBalancerRequestMarshaller().marshall(registerInstancesWithLoadBalancerRequest);
        return this.invoke(request, "//RegisterInstancesWithLoadBalancerResult", new RegisterInstancesWithLoadBalancerResultUnmarshaller());
    }

    @Override
    public DeregisterInstancesFromLoadBalancerResult deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeregisterInstancesFromLoadBalancerRequest> request = new DeregisterInstancesFromLoadBalancerRequestMarshaller().marshall(deregisterInstancesFromLoadBalancerRequest);
        return this.invoke(request, "//DeregisterInstancesFromLoadBalancerResult", new DeregisterInstancesFromLoadBalancerResultUnmarshaller());
    }

    @Override
    public void deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoadBalancerRequest> request = new DeleteLoadBalancerRequestMarshaller().marshall(deleteLoadBalancerRequest);
        this.invoke(request, null, null);
    }

    @Override
    public ConfigureHealthCheckResult configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfigureHealthCheckRequest> request = new ConfigureHealthCheckRequestMarshaller().marshall(configureHealthCheckRequest);
        return this.invoke(request, "//ConfigureHealthCheckResult", new ConfigureHealthCheckResultUnmarshaller());
    }

    @Override
    public EnableAvailabilityZonesForLoadBalancerResult enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableAvailabilityZonesForLoadBalancerRequest> request = new EnableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(enableAvailabilityZonesForLoadBalancerRequest);
        return this.invoke(request, "//EnableAvailabilityZonesForLoadBalancerResult", new EnableAvailabilityZonesForLoadBalancerResultUnmarshaller());
    }

    @Override
    public CreateLBCookieStickinessPolicyResult createLBCookieStickinessPolicy(CreateLBCookieStickinessPolicyRequest createLBCookieStickinessPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLBCookieStickinessPolicyRequest> request = new CreateLBCookieStickinessPolicyRequestMarshaller().marshall(createLBCookieStickinessPolicyRequest);
        return this.invoke(request, "//CreateLBCookieStickinessPolicyResult", new CreateLBCookieStickinessPolicyResultUnmarshaller());
    }

    @Override
    public DeleteLoadBalancerPolicyResult deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoadBalancerPolicyRequest> request = new DeleteLoadBalancerPolicyRequestMarshaller().marshall(deleteLoadBalancerPolicyRequest);
        return this.invoke(request, "//DeleteLoadBalancerPolicyResult", new DeleteLoadBalancerPolicyResultUnmarshaller());
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers() throws AmazonServiceException, AmazonClientException {
        return this.describeLoadBalancers(new DescribeLoadBalancersRequest());
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, String responseElement, Unmarshaller<X, Node> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                request = requestHandler.handleRequest(request);
            }
        }
        QueryStringSigner<Y> signer = new QueryStringSigner<Y>(this.awsCredentials);
        try {
            signer.sign(request);
        }
        catch (SignatureException e) {
            throw new AmazonServiceException("Unable to sign request", e);
        }
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        DefaultResponseHandler<X> responseHandler = new DefaultResponseHandler<X>(unmarshaller, responseElement);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(httpRequest, responseHandler, errorResponseHandler);
    }
}

