/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.HttpClient;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class AmazonWebServiceClient {
    protected URI endpoint;
    protected final ClientConfiguration clientConfiguration;
    protected final HttpClient client;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new HttpClient(clientConfiguration);
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

