/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.model.transform.AttributeDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DuplicateItemNameExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberPredicatesExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberValueTestsExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidQueryExpressionExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NoSuchDomainExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainBytesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberItemAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedItemsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.TooManyRequestedAttributesExceptionUnmarshaller;
import com.amazonaws.transform.LegacyErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleDBClient
extends AmazonWebServiceClient
implements AmazonSimpleDB {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();

    public AmazonSimpleDBClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainBytesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchDomainExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberSubmittedItemsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidQueryExpressionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberSubmittedAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateItemNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNumberPredicatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyRequestedAttributesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberItemAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AttributeDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNumberValueTestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LegacyErrorUnmarshaller());
        this.setEndpoint("sdb.amazonaws.com");
        this.requestHandlers = new HandlerChainFactory().newRequestHandlerChain("/com/amazonaws/services/simpledb/request.handlers");
        this.client = new HttpClient(clientConfiguration);
    }

    @Override
    public SelectResult select(SelectRequest selectRequest) throws AmazonServiceException, AmazonClientException {
        Request<SelectRequest> request = new SelectRequestMarshaller().marshall(selectRequest);
        return this.invoke(request, new SelectResultStaxUnmarshaller());
    }

    @Override
    public void putAttributes(PutAttributesRequest putAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutAttributesRequest> request = new PutAttributesRequestMarshaller().marshall(putAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteDomain(DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDomainRequest> request = new DeleteDomainRequestMarshaller().marshall(deleteDomainRequest);
        this.invoke(request, null);
    }

    @Override
    public void createDomain(CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDomainRequest> request = new CreateDomainRequestMarshaller().marshall(createDomainRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAttributesRequest> request = new DeleteAttributesRequestMarshaller().marshall(deleteAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListDomainsRequest> request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
        return this.invoke(request, new ListDomainsResultStaxUnmarshaller());
    }

    @Override
    public GetAttributesResult getAttributes(GetAttributesRequest getAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetAttributesRequest> request = new GetAttributesRequestMarshaller().marshall(getAttributesRequest);
        return this.invoke(request, new GetAttributesResultStaxUnmarshaller());
    }

    @Override
    public void batchPutAttributes(BatchPutAttributesRequest batchPutAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<BatchPutAttributesRequest> request = new BatchPutAttributesRequestMarshaller().marshall(batchPutAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public DomainMetadataResult domainMetadata(DomainMetadataRequest domainMetadataRequest) throws AmazonServiceException, AmazonClientException {
        Request<DomainMetadataRequest> request = new DomainMetadataRequestMarshaller().marshall(domainMetadataRequest);
        return this.invoke(request, new DomainMetadataResultStaxUnmarshaller());
    }

    @Override
    public ListDomainsResult listDomains() throws AmazonServiceException, AmazonClientException {
        return this.listDomains(new ListDomainsRequest());
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                request = requestHandler.handleRequest(request);
            }
        }
        QueryStringSigner<Y> signer = new QueryStringSigner<Y>(this.awsCredentials);
        try {
            signer.sign(request);
        }
        catch (SignatureException e) {
            throw new AmazonServiceException("Unable to sign request", e);
        }
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(httpRequest, responseHandler, errorResponseHandler);
    }
}

