/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.transform.IpPermissionUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityGroupUnmarshaller
implements Unmarshaller<SecurityGroup, Node> {
    @Override
    public SecurityGroup unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        SecurityGroup securityGroup = new SecurityGroup();
        Node ownerIdNode = XpathUtils.asNode("ownerId", node);
        securityGroup.setOwnerId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ownerIdNode));
        Node groupNameNode = XpathUtils.asNode("groupName", node);
        securityGroup.setGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(groupNameNode));
        Node descriptionNode = XpathUtils.asNode("groupDescription", node);
        securityGroup.setDescription(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(descriptionNode));
        NodeList ipPermissionsNodes = XpathUtils.asNodeList("ipPermissions/item", node);
        for (int ipPermissionsIndex = 0; ipPermissionsIndex < XpathUtils.nodeLength(ipPermissionsNodes); ++ipPermissionsIndex) {
            Node ipPermissionsNode = ipPermissionsNodes.item(ipPermissionsIndex);
            securityGroup.getIpPermissions().add(new IpPermissionUnmarshaller().unmarshall(ipPermissionsNode));
            ipPermissionsNode.getParentNode().removeChild(ipPermissionsNode);
        }
        return securityGroup;
    }
}

