/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.transform.InstanceUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationUnmarshaller
implements Unmarshaller<Reservation, Node> {
    @Override
    public Reservation unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Reservation reservation = new Reservation();
        Node reservationIdNode = XpathUtils.asNode("reservationId", node);
        reservation.setReservationId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(reservationIdNode));
        Node ownerIdNode = XpathUtils.asNode("ownerId", node);
        reservation.setOwnerId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ownerIdNode));
        Node requesterIdNode = XpathUtils.asNode("requesterId", node);
        reservation.setRequesterId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(requesterIdNode));
        NodeList groupNamesNodes = XpathUtils.asNodeList("groupSet/item/groupId", node);
        for (int groupNamesIndex = 0; groupNamesIndex < XpathUtils.nodeLength(groupNamesNodes); ++groupNamesIndex) {
            Node groupNamesNode = groupNamesNodes.item(groupNamesIndex);
            reservation.getGroupNames().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(groupNamesNode));
            groupNamesNode.getParentNode().removeChild(groupNamesNode);
        }
        NodeList instancesNodes = XpathUtils.asNodeList("instancesSet/item", node);
        for (int instancesIndex = 0; instancesIndex < XpathUtils.nodeLength(instancesNodes); ++instancesIndex) {
            Node instancesNode = instancesNodes.item(instancesIndex);
            reservation.getInstances().add(new InstanceUnmarshaller().unmarshall(instancesNode));
            instancesNode.getParentNode().removeChild(instancesNode);
        }
        return reservation;
    }
}

