/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.DateUtils;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class StringUtils {
    private static final DateUtils dateUtils = new DateUtils();

    public static Integer toInteger(StringBuilder value) {
        return Integer.parseInt(value.toString());
    }

    public static String toString(StringBuilder value) {
        return value.toString();
    }

    public static Boolean toBoolean(StringBuilder value) {
        return Boolean.getBoolean(value.toString());
    }

    public static String fromInteger(Integer value) {
        return Integer.toString(value);
    }

    public static String fromLong(Long value) {
        return Long.toString(value);
    }

    public static String fromString(String value) {
        return value;
    }

    public static String fromBoolean(Boolean value) {
        return Boolean.toString(value);
    }

    public static String fromDate(Date value) {
        return dateUtils.formatIso8601Date(value);
    }

    public static String fromDouble(Double d) {
        return Double.toString(d);
    }

    public static String fromByte(Byte b) {
        return Byte.toString(b);
    }

    public static String fromByteBuffer(ByteBuffer byteBuffer) {
        byte[] encodedBytes = null;
        if (byteBuffer.hasArray()) {
            encodedBytes = Base64.encodeBase64((byte[])byteBuffer.array());
        } else {
            byte[] binaryData = new byte[byteBuffer.limit()];
            byteBuffer.get(binaryData);
            encodedBytes = Base64.encodeBase64((byte[])binaryData);
        }
        return new String(encodedBytes);
    }
}

