/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.transform.DBParameterGroupStatusUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupMembershipUnmarshaller;
import com.amazonaws.services.rds.model.transform.EndpointUnmarshaller;
import com.amazonaws.services.rds.model.transform.PendingModifiedValuesUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInstanceUnmarshaller
implements Unmarshaller<DBInstance, Node> {
    @Override
    public DBInstance unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        DBInstance dBInstance = new DBInstance();
        Node dBInstanceIdentifierNode = XpathUtils.asNode("DBInstanceIdentifier", node);
        dBInstance.setDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceIdentifierNode));
        Node dBInstanceClassNode = XpathUtils.asNode("DBInstanceClass", node);
        dBInstance.setDBInstanceClass(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceClassNode));
        Node engineNode = XpathUtils.asNode("Engine", node);
        dBInstance.setEngine(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(engineNode));
        Node dBInstanceStatusNode = XpathUtils.asNode("DBInstanceStatus", node);
        dBInstance.setDBInstanceStatus(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceStatusNode));
        Node masterUsernameNode = XpathUtils.asNode("MasterUsername", node);
        dBInstance.setMasterUsername(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(masterUsernameNode));
        Node dBNameNode = XpathUtils.asNode("DBName", node);
        dBInstance.setDBName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBNameNode));
        Node endpointNode = XpathUtils.asNode("Endpoint", node);
        dBInstance.setEndpoint(new EndpointUnmarshaller().unmarshall(endpointNode));
        Node allocatedStorageNode = XpathUtils.asNode("AllocatedStorage", node);
        dBInstance.setAllocatedStorage(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(allocatedStorageNode));
        Node instanceCreateTimeNode = XpathUtils.asNode("InstanceCreateTime", node);
        dBInstance.setInstanceCreateTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(instanceCreateTimeNode));
        Node preferredBackupWindowNode = XpathUtils.asNode("PreferredBackupWindow", node);
        dBInstance.setPreferredBackupWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredBackupWindowNode));
        Node backupRetentionPeriodNode = XpathUtils.asNode("BackupRetentionPeriod", node);
        dBInstance.setBackupRetentionPeriod(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(backupRetentionPeriodNode));
        NodeList dBSecurityGroupsNodes = XpathUtils.asNodeList("DBSecurityGroups/DBSecurityGroup", node);
        for (int dBSecurityGroupsIndex = 0; dBSecurityGroupsIndex < XpathUtils.nodeLength(dBSecurityGroupsNodes); ++dBSecurityGroupsIndex) {
            Node dBSecurityGroupsNode = dBSecurityGroupsNodes.item(dBSecurityGroupsIndex);
            dBInstance.getDBSecurityGroups().add(new DBSecurityGroupMembershipUnmarshaller().unmarshall(dBSecurityGroupsNode));
            dBSecurityGroupsNode.getParentNode().removeChild(dBSecurityGroupsNode);
        }
        NodeList dBParameterGroupsNodes = XpathUtils.asNodeList("DBParameterGroups/DBParameterGroup", node);
        for (int dBParameterGroupsIndex = 0; dBParameterGroupsIndex < XpathUtils.nodeLength(dBParameterGroupsNodes); ++dBParameterGroupsIndex) {
            Node dBParameterGroupsNode = dBParameterGroupsNodes.item(dBParameterGroupsIndex);
            dBInstance.getDBParameterGroups().add(new DBParameterGroupStatusUnmarshaller().unmarshall(dBParameterGroupsNode));
            dBParameterGroupsNode.getParentNode().removeChild(dBParameterGroupsNode);
        }
        Node availabilityZoneNode = XpathUtils.asNode("AvailabilityZone", node);
        dBInstance.setAvailabilityZone(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZoneNode));
        Node preferredMaintenanceWindowNode = XpathUtils.asNode("PreferredMaintenanceWindow", node);
        dBInstance.setPreferredMaintenanceWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredMaintenanceWindowNode));
        Node pendingModifiedValuesNode = XpathUtils.asNode("PendingModifiedValues", node);
        dBInstance.setPendingModifiedValues(new PendingModifiedValuesUnmarshaller().unmarshall(pendingModifiedValuesNode));
        Node latestRestorableTimeNode = XpathUtils.asNode("LatestRestorableTime", node);
        dBInstance.setLatestRestorableTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(latestRestorableTimeNode));
        return dBInstance;
    }
}

