/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthCheckUnmarshaller
implements Unmarshaller<HealthCheck, Node> {
    @Override
    public HealthCheck unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        HealthCheck healthCheck = new HealthCheck();
        Node targetNode = XpathUtils.asNode("Target", node);
        healthCheck.setTarget(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(targetNode));
        Node intervalNode = XpathUtils.asNode("Interval", node);
        healthCheck.setInterval(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(intervalNode));
        Node timeoutNode = XpathUtils.asNode("Timeout", node);
        healthCheck.setTimeout(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(timeoutNode));
        Node unhealthyThresholdNode = XpathUtils.asNode("UnhealthyThreshold", node);
        healthCheck.setUnhealthyThreshold(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(unhealthyThresholdNode));
        Node healthyThresholdNode = XpathUtils.asNode("HealthyThreshold", node);
        healthCheck.setHealthyThreshold(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(healthyThresholdNode));
        return healthCheck;
    }
}

