/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    @Override
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        DefaultRequest<DescribeAddressesRequest> request = new DefaultRequest<DescribeAddressesRequest>(describeAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2009-11-30");
        if (describeAddressesRequest != null) {
            List<String> publicIpsList = describeAddressesRequest.getPublicIps();
            int publicIpsListIndex = 1;
            for (String publicIpsListValue : publicIpsList) {
                if (publicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString(publicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        return request;
    }
}

