/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.InsightEvent;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InsightEventMarshaller {
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Summary").build();
    private static final MarshallingInfo<Date> EVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> CLIENTREQUESTIMPACTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestImpactStatistics").build();
    private static final MarshallingInfo<StructuredPojo> ROOTCAUSESERVICEREQUESTIMPACTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootCauseServiceRequestImpactStatistics").build();
    private static final MarshallingInfo<List> TOPANOMALOUSSERVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopAnomalousServices").build();
    private static final InsightEventMarshaller instance = new InsightEventMarshaller();

    public static InsightEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(InsightEvent insightEvent, ProtocolMarshaller protocolMarshaller) {
        if (insightEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)insightEvent.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)insightEvent.getEventTime(), EVENTTIME_BINDING);
            protocolMarshaller.marshall((Object)insightEvent.getClientRequestImpactStatistics(), CLIENTREQUESTIMPACTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)insightEvent.getRootCauseServiceRequestImpactStatistics(), ROOTCAUSESERVICEREQUESTIMPACTSTATISTICS_BINDING);
            protocolMarshaller.marshall(insightEvent.getTopAnomalousServices(), TOPANOMALOUSSERVICES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

