/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.Http;

public class HttpJsonMarshaller {
    private static HttpJsonMarshaller instance;

    public void marshall(Http http, StructuredJsonGenerator jsonGenerator) {
        if (http == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (http.getHttpURL() != null) {
                jsonGenerator.writeFieldName("HttpURL").writeValue(http.getHttpURL());
            }
            if (http.getHttpStatus() != null) {
                jsonGenerator.writeFieldName("HttpStatus").writeValue(http.getHttpStatus().intValue());
            }
            if (http.getHttpMethod() != null) {
                jsonGenerator.writeFieldName("HttpMethod").writeValue(http.getHttpMethod());
            }
            if (http.getUserAgent() != null) {
                jsonGenerator.writeFieldName("UserAgent").writeValue(http.getUserAgent());
            }
            if (http.getClientIp() != null) {
                jsonGenerator.writeFieldName("ClientIp").writeValue(http.getClientIp());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HttpJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HttpJsonMarshaller();
        }
        return instance;
    }
}

