/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.ValueWithServiceIds;
import com.amazonaws.services.xray.model.transform.AnnotationValueJsonMarshaller;
import com.amazonaws.services.xray.model.transform.ServiceIdJsonMarshaller;
import java.util.List;

public class ValueWithServiceIdsJsonMarshaller {
    private static ValueWithServiceIdsJsonMarshaller instance;

    public void marshall(ValueWithServiceIds valueWithServiceIds, StructuredJsonGenerator jsonGenerator) {
        if (valueWithServiceIds == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ServiceId> serviceIdsList;
            jsonGenerator.writeStartObject();
            if (valueWithServiceIds.getAnnotationValue() != null) {
                jsonGenerator.writeFieldName("AnnotationValue");
                AnnotationValueJsonMarshaller.getInstance().marshall(valueWithServiceIds.getAnnotationValue(), jsonGenerator);
            }
            if ((serviceIdsList = valueWithServiceIds.getServiceIds()) != null) {
                jsonGenerator.writeFieldName("ServiceIds");
                jsonGenerator.writeStartArray();
                for (ServiceId serviceIdsListValue : serviceIdsList) {
                    if (serviceIdsListValue == null) continue;
                    ServiceIdJsonMarshaller.getInstance().marshall(serviceIdsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ValueWithServiceIdsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ValueWithServiceIdsJsonMarshaller();
        }
        return instance;
    }
}

