/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.AWSXRayClientBuilder;
import com.amazonaws.services.xray.model.AWSXRayException;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.GetEncryptionConfigRequest;
import com.amazonaws.services.xray.model.GetEncryptionConfigResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.InvalidRequestException;
import com.amazonaws.services.xray.model.PutEncryptionConfigRequest;
import com.amazonaws.services.xray.model.PutEncryptionConfigResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import com.amazonaws.services.xray.model.ThrottledException;
import com.amazonaws.services.xray.model.transform.BatchGetTracesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.BatchGetTracesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSXRayClient
extends AmazonWebServiceClient
implements AWSXRay {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSXRay.class);
    private static final String DEFAULT_SIGNING_NAME = "xray";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledException").withModeledClass(ThrottledException.class)).withBaseServiceExceptionClass(AWSXRayException.class));

    @Deprecated
    public AWSXRayClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSXRayClientBuilder builder() {
        return AWSXRayClientBuilder.standard();
    }

    AWSXRayClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSXRayClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("xray.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/xray/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/xray/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetTracesResult batchGetTraces(BatchGetTracesRequest request) {
        request = (BatchGetTracesRequest)this.beforeClientExecution(request);
        return this.executeBatchGetTraces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetTracesResult executeBatchGetTraces(BatchGetTracesRequest batchGetTracesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetTracesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetTracesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetTracesRequestProtocolMarshaller(protocolFactory).marshall((BatchGetTracesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetTracesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetTraces");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetTracesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetTracesResult batchGetTracesResult = (BatchGetTracesResult)response.getAwsResponse();
            return batchGetTracesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEncryptionConfigResult getEncryptionConfig(GetEncryptionConfigRequest request) {
        request = (GetEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executeGetEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEncryptionConfigResult executeGetEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((GetEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEncryptionConfig");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEncryptionConfigResult getEncryptionConfigResult = (GetEncryptionConfigResult)response.getAwsResponse();
            return getEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceGraphResult getServiceGraph(GetServiceGraphRequest request) {
        request = (GetServiceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetServiceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceGraphResult executeGetServiceGraph(GetServiceGraphRequest getServiceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetServiceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetServiceGraph");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceGraphResult getServiceGraphResult = (GetServiceGraphResult)response.getAwsResponse();
            return getServiceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceGraphResult getTraceGraph(GetTraceGraphRequest request) {
        request = (GetTraceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetTraceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceGraphResult executeGetTraceGraph(GetTraceGraphRequest getTraceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetTraceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceGraph");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceGraphResult getTraceGraphResult = (GetTraceGraphResult)response.getAwsResponse();
            return getTraceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceSummariesResult getTraceSummaries(GetTraceSummariesRequest request) {
        request = (GetTraceSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetTraceSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceSummariesResult executeGetTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetTraceSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceSummaries");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceSummariesResult getTraceSummariesResult = (GetTraceSummariesResult)response.getAwsResponse();
            return getTraceSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEncryptionConfigResult putEncryptionConfig(PutEncryptionConfigRequest request) {
        request = (PutEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executePutEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEncryptionConfigResult executePutEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((PutEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutEncryptionConfig");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEncryptionConfigResult putEncryptionConfigResult = (PutEncryptionConfigResult)response.getAwsResponse();
            return putEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTelemetryRecordsResult putTelemetryRecords(PutTelemetryRecordsRequest request) {
        request = (PutTelemetryRecordsRequest)this.beforeClientExecution(request);
        return this.executePutTelemetryRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTelemetryRecordsResult executePutTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTelemetryRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTelemetryRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTelemetryRecordsRequestProtocolMarshaller(protocolFactory).marshall((PutTelemetryRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTelemetryRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTelemetryRecords");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTelemetryRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTelemetryRecordsResult putTelemetryRecordsResult = (PutTelemetryRecordsResult)response.getAwsResponse();
            return putTelemetryRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTraceSegmentsResult putTraceSegments(PutTraceSegmentsRequest request) {
        request = (PutTraceSegmentsRequest)this.beforeClientExecution(request);
        return this.executePutTraceSegments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTraceSegmentsResult executePutTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTraceSegmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTraceSegmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTraceSegmentsRequestProtocolMarshaller(protocolFactory).marshall((PutTraceSegmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTraceSegmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTraceSegments");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTraceSegmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTraceSegmentsResult putTraceSegmentsResult = (PutTraceSegmentsResult)response.getAwsResponse();
            return putTraceSegmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

