/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateTrustStoreRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     */
    private java.util.List<java.nio.ByteBuffer> certificatesToAdd;
    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     */
    private java.util.List<String> certificatesToDelete;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     */
    private String trustStoreArn;

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     * 
     * @return A list of CA certificates to add to the trust store.
     */

    public java.util.List<java.nio.ByteBuffer> getCertificatesToAdd() {
        return certificatesToAdd;
    }

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     * 
     * @param certificatesToAdd
     *        A list of CA certificates to add to the trust store.
     */

    public void setCertificatesToAdd(java.util.Collection<java.nio.ByteBuffer> certificatesToAdd) {
        if (certificatesToAdd == null) {
            this.certificatesToAdd = null;
            return;
        }

        this.certificatesToAdd = new java.util.ArrayList<java.nio.ByteBuffer>(certificatesToAdd);
    }

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCertificatesToAdd(java.util.Collection)} or {@link #withCertificatesToAdd(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param certificatesToAdd
     *        A list of CA certificates to add to the trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withCertificatesToAdd(java.nio.ByteBuffer... certificatesToAdd) {
        if (this.certificatesToAdd == null) {
            setCertificatesToAdd(new java.util.ArrayList<java.nio.ByteBuffer>(certificatesToAdd.length));
        }
        for (java.nio.ByteBuffer ele : certificatesToAdd) {
            this.certificatesToAdd.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     * 
     * @param certificatesToAdd
     *        A list of CA certificates to add to the trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withCertificatesToAdd(java.util.Collection<java.nio.ByteBuffer> certificatesToAdd) {
        setCertificatesToAdd(certificatesToAdd);
        return this;
    }

    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     * 
     * @return A list of CA certificates to delete from a trust store.
     */

    public java.util.List<String> getCertificatesToDelete() {
        return certificatesToDelete;
    }

    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     * 
     * @param certificatesToDelete
     *        A list of CA certificates to delete from a trust store.
     */

    public void setCertificatesToDelete(java.util.Collection<String> certificatesToDelete) {
        if (certificatesToDelete == null) {
            this.certificatesToDelete = null;
            return;
        }

        this.certificatesToDelete = new java.util.ArrayList<String>(certificatesToDelete);
    }

    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCertificatesToDelete(java.util.Collection)} or {@link #withCertificatesToDelete(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param certificatesToDelete
     *        A list of CA certificates to delete from a trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withCertificatesToDelete(String... certificatesToDelete) {
        if (this.certificatesToDelete == null) {
            setCertificatesToDelete(new java.util.ArrayList<String>(certificatesToDelete.length));
        }
        for (String ele : certificatesToDelete) {
            this.certificatesToDelete.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     * 
     * @param certificatesToDelete
     *        A list of CA certificates to delete from a trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withCertificatesToDelete(java.util.Collection<String> certificatesToDelete) {
        setCertificatesToDelete(certificatesToDelete);
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     * 
     * @param trustStoreArn
     *        The ARN of the trust store.
     */

    public void setTrustStoreArn(String trustStoreArn) {
        this.trustStoreArn = trustStoreArn;
    }

    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     * 
     * @return The ARN of the trust store.
     */

    public String getTrustStoreArn() {
        return this.trustStoreArn;
    }

    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     * 
     * @param trustStoreArn
     *        The ARN of the trust store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTrustStoreRequest withTrustStoreArn(String trustStoreArn) {
        setTrustStoreArn(trustStoreArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCertificatesToAdd() != null)
            sb.append("CertificatesToAdd: ").append(getCertificatesToAdd()).append(",");
        if (getCertificatesToDelete() != null)
            sb.append("CertificatesToDelete: ").append(getCertificatesToDelete()).append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getTrustStoreArn() != null)
            sb.append("TrustStoreArn: ").append(getTrustStoreArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateTrustStoreRequest == false)
            return false;
        UpdateTrustStoreRequest other = (UpdateTrustStoreRequest) obj;
        if (other.getCertificatesToAdd() == null ^ this.getCertificatesToAdd() == null)
            return false;
        if (other.getCertificatesToAdd() != null && other.getCertificatesToAdd().equals(this.getCertificatesToAdd()) == false)
            return false;
        if (other.getCertificatesToDelete() == null ^ this.getCertificatesToDelete() == null)
            return false;
        if (other.getCertificatesToDelete() != null && other.getCertificatesToDelete().equals(this.getCertificatesToDelete()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getTrustStoreArn() == null ^ this.getTrustStoreArn() == null)
            return false;
        if (other.getTrustStoreArn() != null && other.getTrustStoreArn().equals(this.getTrustStoreArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCertificatesToAdd() == null) ? 0 : getCertificatesToAdd().hashCode());
        hashCode = prime * hashCode + ((getCertificatesToDelete() == null) ? 0 : getCertificatesToDelete().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getTrustStoreArn() == null) ? 0 : getTrustStoreArn().hashCode());
        return hashCode;
    }

    @Override
    public UpdateTrustStoreRequest clone() {
        return (UpdateTrustStoreRequest) super.clone();
    }

}
