/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateUserAccessLoggingSettingsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     */
    private String kinesisStreamArn;
    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     */
    private String userAccessLoggingSettingsArn;

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateUserAccessLoggingSettingsRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @param kinesisStreamArn
     *        The ARN of the Kinesis stream.
     */

    public void setKinesisStreamArn(String kinesisStreamArn) {
        this.kinesisStreamArn = kinesisStreamArn;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @return The ARN of the Kinesis stream.
     */

    public String getKinesisStreamArn() {
        return this.kinesisStreamArn;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @param kinesisStreamArn
     *        The ARN of the Kinesis stream.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateUserAccessLoggingSettingsRequest withKinesisStreamArn(String kinesisStreamArn) {
        setKinesisStreamArn(kinesisStreamArn);
        return this;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @param userAccessLoggingSettingsArn
     *        The ARN of the user access logging settings.
     */

    public void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
        this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @return The ARN of the user access logging settings.
     */

    public String getUserAccessLoggingSettingsArn() {
        return this.userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @param userAccessLoggingSettingsArn
     *        The ARN of the user access logging settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateUserAccessLoggingSettingsRequest withUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
        setUserAccessLoggingSettingsArn(userAccessLoggingSettingsArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getKinesisStreamArn() != null)
            sb.append("KinesisStreamArn: ").append(getKinesisStreamArn()).append(",");
        if (getUserAccessLoggingSettingsArn() != null)
            sb.append("UserAccessLoggingSettingsArn: ").append(getUserAccessLoggingSettingsArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateUserAccessLoggingSettingsRequest == false)
            return false;
        UpdateUserAccessLoggingSettingsRequest other = (UpdateUserAccessLoggingSettingsRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getKinesisStreamArn() == null ^ this.getKinesisStreamArn() == null)
            return false;
        if (other.getKinesisStreamArn() != null && other.getKinesisStreamArn().equals(this.getKinesisStreamArn()) == false)
            return false;
        if (other.getUserAccessLoggingSettingsArn() == null ^ this.getUserAccessLoggingSettingsArn() == null)
            return false;
        if (other.getUserAccessLoggingSettingsArn() != null && other.getUserAccessLoggingSettingsArn().equals(this.getUserAccessLoggingSettingsArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getKinesisStreamArn() == null) ? 0 : getKinesisStreamArn().hashCode());
        hashCode = prime * hashCode + ((getUserAccessLoggingSettingsArn() == null) ? 0 : getUserAccessLoggingSettingsArn().hashCode());
        return hashCode;
    }

    @Override
    public UpdateUserAccessLoggingSettingsRequest clone() {
        return (UpdateUserAccessLoggingSettingsRequest) super.clone();
    }

}
