/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspacesweb.model.transform.BrowserSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrowserSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> associatedPortalArns;
    private String browserPolicy;
    private String browserSettingsArn;

    public List<String> getAssociatedPortalArns() {
        return this.associatedPortalArns;
    }

    public void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
        if (associatedPortalArns == null) {
            this.associatedPortalArns = null;
            return;
        }
        this.associatedPortalArns = new ArrayList<String>(associatedPortalArns);
    }

    public BrowserSettings withAssociatedPortalArns(String ... associatedPortalArns) {
        if (this.associatedPortalArns == null) {
            this.setAssociatedPortalArns(new ArrayList<String>(associatedPortalArns.length));
        }
        for (String ele : associatedPortalArns) {
            this.associatedPortalArns.add(ele);
        }
        return this;
    }

    public BrowserSettings withAssociatedPortalArns(Collection<String> associatedPortalArns) {
        this.setAssociatedPortalArns(associatedPortalArns);
        return this;
    }

    public void setBrowserPolicy(String browserPolicy) {
        this.browserPolicy = browserPolicy;
    }

    public String getBrowserPolicy() {
        return this.browserPolicy;
    }

    public BrowserSettings withBrowserPolicy(String browserPolicy) {
        this.setBrowserPolicy(browserPolicy);
        return this;
    }

    public void setBrowserSettingsArn(String browserSettingsArn) {
        this.browserSettingsArn = browserSettingsArn;
    }

    public String getBrowserSettingsArn() {
        return this.browserSettingsArn;
    }

    public BrowserSettings withBrowserSettingsArn(String browserSettingsArn) {
        this.setBrowserSettingsArn(browserSettingsArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociatedPortalArns() != null) {
            sb.append("AssociatedPortalArns: ").append(this.getAssociatedPortalArns()).append(",");
        }
        if (this.getBrowserPolicy() != null) {
            sb.append("BrowserPolicy: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getBrowserSettingsArn() != null) {
            sb.append("BrowserSettingsArn: ").append(this.getBrowserSettingsArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSettings)) {
            return false;
        }
        BrowserSettings other = (BrowserSettings)obj;
        if (other.getAssociatedPortalArns() == null ^ this.getAssociatedPortalArns() == null) {
            return false;
        }
        if (other.getAssociatedPortalArns() != null && !other.getAssociatedPortalArns().equals(this.getAssociatedPortalArns())) {
            return false;
        }
        if (other.getBrowserPolicy() == null ^ this.getBrowserPolicy() == null) {
            return false;
        }
        if (other.getBrowserPolicy() != null && !other.getBrowserPolicy().equals(this.getBrowserPolicy())) {
            return false;
        }
        if (other.getBrowserSettingsArn() == null ^ this.getBrowserSettingsArn() == null) {
            return false;
        }
        return other.getBrowserSettingsArn() == null || other.getBrowserSettingsArn().equals(this.getBrowserSettingsArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociatedPortalArns() == null ? 0 : this.getAssociatedPortalArns().hashCode());
        hashCode = 31 * hashCode + (this.getBrowserPolicy() == null ? 0 : this.getBrowserPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getBrowserSettingsArn() == null ? 0 : this.getBrowserSettingsArn().hashCode());
        return hashCode;
    }

    public BrowserSettings clone() {
        try {
            return (BrowserSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrowserSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

