/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesthinclient.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workspacesthinclient.model.DeviceSummary;
import java.util.Date;

@SdkInternalApi
public class DeviceSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> SERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serialNumber").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("model").build();
    private static final MarshallingInfo<String> ENVIRONMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CURRENTSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentSoftwareSetId").build();
    private static final MarshallingInfo<String> DESIREDSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredSoftwareSetId").build();
    private static final MarshallingInfo<String> PENDINGSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pendingSoftwareSetId").build();
    private static final MarshallingInfo<String> SOFTWARESETUPDATESCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softwareSetUpdateSchedule").build();
    private static final MarshallingInfo<Date> LASTCONNECTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastConnectedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTPOSTUREAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastPostureAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final DeviceSummaryMarshaller instance = new DeviceSummaryMarshaller();

    public static DeviceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceSummary deviceSummary, ProtocolMarshaller protocolMarshaller) {
        if (deviceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceSummary.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getSerialNumber(), SERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getModel(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getEnvironmentId(), ENVIRONMENTID_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getCurrentSoftwareSetId(), CURRENTSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getDesiredSoftwareSetId(), DESIREDSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getPendingSoftwareSetId(), PENDINGSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getSoftwareSetUpdateSchedule(), SOFTWARESETUPDATESCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getLastConnectedAt(), LASTCONNECTEDAT_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getLastPostureAt(), LASTPOSTUREAT_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getUpdatedAt(), UPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getArn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

