/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeWorkspaceBundlesRequestMarshaller
implements Marshaller<Request<DescribeWorkspaceBundlesRequest>, DescribeWorkspaceBundlesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeWorkspaceBundlesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeWorkspaceBundlesRequest> marshall(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        if (describeWorkspaceBundlesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeWorkspaceBundlesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspaceBundles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList bundleIdsList = (SdkInternalList)describeWorkspaceBundlesRequest.getBundleIds();
            if (!bundleIdsList.isEmpty() || !bundleIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("BundleIds");
                jsonGenerator.writeStartArray();
                for (String bundleIdsListValue : bundleIdsList) {
                    if (bundleIdsListValue == null) continue;
                    jsonGenerator.writeValue(bundleIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeWorkspaceBundlesRequest.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(describeWorkspaceBundlesRequest.getOwner());
            }
            if (describeWorkspaceBundlesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeWorkspaceBundlesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

