/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.StopRequest;
import com.amazonaws.services.workspaces.model.StopWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.StopRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StopWorkspacesRequestMarshaller
implements Marshaller<Request<StopWorkspacesRequest>, StopWorkspacesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StopWorkspacesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StopWorkspacesRequest> marshall(StopWorkspacesRequest stopWorkspacesRequest) {
        if (stopWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)stopWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.StopWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList stopWorkspaceRequestsList = (SdkInternalList)stopWorkspacesRequest.getStopWorkspaceRequests();
            if (!stopWorkspaceRequestsList.isEmpty() || !stopWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StopWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (StopRequest stopWorkspaceRequestsListValue : stopWorkspaceRequestsList) {
                    if (stopWorkspaceRequestsListValue == null) continue;
                    StopRequestJsonMarshaller.getInstance().marshall(stopWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

