/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.DefaultWorkspaceCreationProperties;
import com.amazonaws.services.workspaces.model.WorkspaceDirectoryState;
import com.amazonaws.services.workspaces.model.WorkspaceDirectoryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkspaceDirectory
implements Serializable,
Cloneable {
    private String directoryId;
    private String alias;
    private String directoryName;
    private String registrationCode;
    private ListWithAutoConstructFlag<String> subnetIds;
    private ListWithAutoConstructFlag<String> dnsIpAddresses;
    private String customerUserName;
    private String iamRoleId;
    private String directoryType;
    private String workspaceSecurityGroupId;
    private String state;
    private DefaultWorkspaceCreationProperties workspaceCreationProperties;

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public WorkspaceDirectory withDirectoryId(String directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public WorkspaceDirectory withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public WorkspaceDirectory withDirectoryName(String directoryName) {
        this.directoryName = directoryName;
        return this;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public WorkspaceDirectory withRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new ListWithAutoConstructFlag();
            this.subnetIds.setAutoConstruct(true);
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
        subnetIdsCopy.addAll(subnetIds);
        this.subnetIds = subnetIdsCopy;
    }

    public WorkspaceDirectory withSubnetIds(String ... subnetIds) {
        if (this.getSubnetIds() == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String value : subnetIds) {
            this.getSubnetIds().add(value);
        }
        return this;
    }

    public WorkspaceDirectory withSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
        } else {
            ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
            subnetIdsCopy.addAll(subnetIds);
            this.subnetIds = subnetIdsCopy;
        }
        return this;
    }

    public List<String> getDnsIpAddresses() {
        if (this.dnsIpAddresses == null) {
            this.dnsIpAddresses = new ListWithAutoConstructFlag();
            this.dnsIpAddresses.setAutoConstruct(true);
        }
        return this.dnsIpAddresses;
    }

    public void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
        if (dnsIpAddresses == null) {
            this.dnsIpAddresses = null;
            return;
        }
        ListWithAutoConstructFlag dnsIpAddressesCopy = new ListWithAutoConstructFlag(dnsIpAddresses.size());
        dnsIpAddressesCopy.addAll(dnsIpAddresses);
        this.dnsIpAddresses = dnsIpAddressesCopy;
    }

    public WorkspaceDirectory withDnsIpAddresses(String ... dnsIpAddresses) {
        if (this.getDnsIpAddresses() == null) {
            this.setDnsIpAddresses(new ArrayList<String>(dnsIpAddresses.length));
        }
        for (String value : dnsIpAddresses) {
            this.getDnsIpAddresses().add(value);
        }
        return this;
    }

    public WorkspaceDirectory withDnsIpAddresses(Collection<String> dnsIpAddresses) {
        if (dnsIpAddresses == null) {
            this.dnsIpAddresses = null;
        } else {
            ListWithAutoConstructFlag dnsIpAddressesCopy = new ListWithAutoConstructFlag(dnsIpAddresses.size());
            dnsIpAddressesCopy.addAll(dnsIpAddresses);
            this.dnsIpAddresses = dnsIpAddressesCopy;
        }
        return this;
    }

    public String getCustomerUserName() {
        return this.customerUserName;
    }

    public void setCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
    }

    public WorkspaceDirectory withCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
        return this;
    }

    public String getIamRoleId() {
        return this.iamRoleId;
    }

    public void setIamRoleId(String iamRoleId) {
        this.iamRoleId = iamRoleId;
    }

    public WorkspaceDirectory withIamRoleId(String iamRoleId) {
        this.iamRoleId = iamRoleId;
        return this;
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public WorkspaceDirectory withDirectoryType(String directoryType) {
        this.directoryType = directoryType;
        return this;
    }

    public void setDirectoryType(WorkspaceDirectoryType directoryType) {
        this.directoryType = directoryType.toString();
    }

    public WorkspaceDirectory withDirectoryType(WorkspaceDirectoryType directoryType) {
        this.directoryType = directoryType.toString();
        return this;
    }

    public String getWorkspaceSecurityGroupId() {
        return this.workspaceSecurityGroupId;
    }

    public void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
        this.workspaceSecurityGroupId = workspaceSecurityGroupId;
    }

    public WorkspaceDirectory withWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
        this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public WorkspaceDirectory withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(WorkspaceDirectoryState state) {
        this.state = state.toString();
    }

    public WorkspaceDirectory withState(WorkspaceDirectoryState state) {
        this.state = state.toString();
        return this;
    }

    public DefaultWorkspaceCreationProperties getWorkspaceCreationProperties() {
        return this.workspaceCreationProperties;
    }

    public void setWorkspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
        this.workspaceCreationProperties = workspaceCreationProperties;
    }

    public WorkspaceDirectory withWorkspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
        this.workspaceCreationProperties = workspaceCreationProperties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: " + this.getDirectoryId() + ",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: " + this.getAlias() + ",");
        }
        if (this.getDirectoryName() != null) {
            sb.append("DirectoryName: " + this.getDirectoryName() + ",");
        }
        if (this.getRegistrationCode() != null) {
            sb.append("RegistrationCode: " + this.getRegistrationCode() + ",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: " + this.getSubnetIds() + ",");
        }
        if (this.getDnsIpAddresses() != null) {
            sb.append("DnsIpAddresses: " + this.getDnsIpAddresses() + ",");
        }
        if (this.getCustomerUserName() != null) {
            sb.append("CustomerUserName: " + this.getCustomerUserName() + ",");
        }
        if (this.getIamRoleId() != null) {
            sb.append("IamRoleId: " + this.getIamRoleId() + ",");
        }
        if (this.getDirectoryType() != null) {
            sb.append("DirectoryType: " + this.getDirectoryType() + ",");
        }
        if (this.getWorkspaceSecurityGroupId() != null) {
            sb.append("WorkspaceSecurityGroupId: " + this.getWorkspaceSecurityGroupId() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getWorkspaceCreationProperties() != null) {
            sb.append("WorkspaceCreationProperties: " + this.getWorkspaceCreationProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryName() == null ? 0 : this.getDirectoryName().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrationCode() == null ? 0 : this.getRegistrationCode().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIpAddresses() == null ? 0 : this.getDnsIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerUserName() == null ? 0 : this.getCustomerUserName().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleId() == null ? 0 : this.getIamRoleId().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryType() == null ? 0 : this.getDirectoryType().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceSecurityGroupId() == null ? 0 : this.getWorkspaceSecurityGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceCreationProperties() == null ? 0 : this.getWorkspaceCreationProperties().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDirectory)) {
            return false;
        }
        WorkspaceDirectory other = (WorkspaceDirectory)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getDirectoryName() == null ^ this.getDirectoryName() == null) {
            return false;
        }
        if (other.getDirectoryName() != null && !other.getDirectoryName().equals(this.getDirectoryName())) {
            return false;
        }
        if (other.getRegistrationCode() == null ^ this.getRegistrationCode() == null) {
            return false;
        }
        if (other.getRegistrationCode() != null && !other.getRegistrationCode().equals(this.getRegistrationCode())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getDnsIpAddresses() == null ^ this.getDnsIpAddresses() == null) {
            return false;
        }
        if (other.getDnsIpAddresses() != null && !other.getDnsIpAddresses().equals(this.getDnsIpAddresses())) {
            return false;
        }
        if (other.getCustomerUserName() == null ^ this.getCustomerUserName() == null) {
            return false;
        }
        if (other.getCustomerUserName() != null && !other.getCustomerUserName().equals(this.getCustomerUserName())) {
            return false;
        }
        if (other.getIamRoleId() == null ^ this.getIamRoleId() == null) {
            return false;
        }
        if (other.getIamRoleId() != null && !other.getIamRoleId().equals(this.getIamRoleId())) {
            return false;
        }
        if (other.getDirectoryType() == null ^ this.getDirectoryType() == null) {
            return false;
        }
        if (other.getDirectoryType() != null && !other.getDirectoryType().equals(this.getDirectoryType())) {
            return false;
        }
        if (other.getWorkspaceSecurityGroupId() == null ^ this.getWorkspaceSecurityGroupId() == null) {
            return false;
        }
        if (other.getWorkspaceSecurityGroupId() != null && !other.getWorkspaceSecurityGroupId().equals(this.getWorkspaceSecurityGroupId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getWorkspaceCreationProperties() == null ^ this.getWorkspaceCreationProperties() == null) {
            return false;
        }
        return other.getWorkspaceCreationProperties() == null || other.getWorkspaceCreationProperties().equals(this.getWorkspaceCreationProperties());
    }

    public WorkspaceDirectory clone() {
        try {
            return (WorkspaceDirectory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

