/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmailmessageflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workmailmessageflow.model.S3Reference;

@SdkInternalApi
public class S3ReferenceMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> OBJECTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectVersion").build();
    private static final S3ReferenceMarshaller instance = new S3ReferenceMarshaller();

    public static S3ReferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Reference s3Reference, ProtocolMarshaller protocolMarshaller) {
        if (s3Reference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Reference.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Reference.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3Reference.getObjectVersion(), OBJECTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

