/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workmail.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListGroupsForEntityRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier for the organization under which the entity exists.
     * </p>
     */
    private String organizationId;
    /**
     * <p>
     * The identifier for the entity.
     * </p>
     * <p>
     * The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     */
    private String entityId;
    /**
     * <p>
     * Limit the search results based on the filter criteria.
     * </p>
     */
    private ListGroupsForEntityFilters filters;
    /**
     * <p>
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The identifier for the organization under which the entity exists.
     * </p>
     * 
     * @param organizationId
     *        The identifier for the organization under which the entity exists.
     */

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * <p>
     * The identifier for the organization under which the entity exists.
     * </p>
     * 
     * @return The identifier for the organization under which the entity exists.
     */

    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * <p>
     * The identifier for the organization under which the entity exists.
     * </p>
     * 
     * @param organizationId
     *        The identifier for the organization under which the entity exists.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupsForEntityRequest withOrganizationId(String organizationId) {
        setOrganizationId(organizationId);
        return this;
    }

    /**
     * <p>
     * The identifier for the entity.
     * </p>
     * <p>
     * The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     * 
     * @param entityId
     *        The identifier for the entity.</p>
     *        <p>
     *        The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Email address: entity@domain.tld
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Entity name: entity
     *        </p>
     *        </li>
     */

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    /**
     * <p>
     * The identifier for the entity.
     * </p>
     * <p>
     * The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the entity.</p>
     *         <p>
     *         The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: entity@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Entity name: entity
     *         </p>
     *         </li>
     */

    public String getEntityId() {
        return this.entityId;
    }

    /**
     * <p>
     * The identifier for the entity.
     * </p>
     * <p>
     * The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     * 
     * @param entityId
     *        The identifier for the entity.</p>
     *        <p>
     *        The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Email address: entity@domain.tld
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Entity name: entity
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupsForEntityRequest withEntityId(String entityId) {
        setEntityId(entityId);
        return this;
    }

    /**
     * <p>
     * Limit the search results based on the filter criteria.
     * </p>
     * 
     * @param filters
     *        Limit the search results based on the filter criteria.
     */

    public void setFilters(ListGroupsForEntityFilters filters) {
        this.filters = filters;
    }

    /**
     * <p>
     * Limit the search results based on the filter criteria.
     * </p>
     * 
     * @return Limit the search results based on the filter criteria.
     */

    public ListGroupsForEntityFilters getFilters() {
        return this.filters;
    }

    /**
     * <p>
     * Limit the search results based on the filter criteria.
     * </p>
     * 
     * @param filters
     *        Limit the search results based on the filter criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupsForEntityRequest withFilters(ListGroupsForEntityFilters filters) {
        setFilters(filters);
        return this;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. The first call does not contain any tokens.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. The first call does not contain any tokens.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupsForEntityRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in a single call.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in a single call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupsForEntityRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOrganizationId() != null)
            sb.append("OrganizationId: ").append(getOrganizationId()).append(",");
        if (getEntityId() != null)
            sb.append("EntityId: ").append(getEntityId()).append(",");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListGroupsForEntityRequest == false)
            return false;
        ListGroupsForEntityRequest other = (ListGroupsForEntityRequest) obj;
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null)
            return false;
        if (other.getOrganizationId() != null && other.getOrganizationId().equals(this.getOrganizationId()) == false)
            return false;
        if (other.getEntityId() == null ^ this.getEntityId() == null)
            return false;
        if (other.getEntityId() != null && other.getEntityId().equals(this.getEntityId()) == false)
            return false;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOrganizationId() == null) ? 0 : getOrganizationId().hashCode());
        hashCode = prime * hashCode + ((getEntityId() == null) ? 0 : getEntityId().hashCode());
        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListGroupsForEntityRequest clone() {
        return (ListGroupsForEntityRequest) super.clone();
    }

}
