/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.worklink;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.worklink.AmazonWorkLinkAsync;
import com.amazonaws.services.worklink.AmazonWorkLinkAsyncClientBuilder;
import com.amazonaws.services.worklink.AmazonWorkLinkClient;
import com.amazonaws.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest;
import com.amazonaws.services.worklink.model.AssociateWebsiteCertificateAuthorityResult;
import com.amazonaws.services.worklink.model.CreateFleetRequest;
import com.amazonaws.services.worklink.model.CreateFleetResult;
import com.amazonaws.services.worklink.model.DeleteFleetRequest;
import com.amazonaws.services.worklink.model.DeleteFleetResult;
import com.amazonaws.services.worklink.model.DescribeAuditStreamConfigurationRequest;
import com.amazonaws.services.worklink.model.DescribeAuditStreamConfigurationResult;
import com.amazonaws.services.worklink.model.DescribeCompanyNetworkConfigurationRequest;
import com.amazonaws.services.worklink.model.DescribeCompanyNetworkConfigurationResult;
import com.amazonaws.services.worklink.model.DescribeDevicePolicyConfigurationRequest;
import com.amazonaws.services.worklink.model.DescribeDevicePolicyConfigurationResult;
import com.amazonaws.services.worklink.model.DescribeDeviceRequest;
import com.amazonaws.services.worklink.model.DescribeDeviceResult;
import com.amazonaws.services.worklink.model.DescribeFleetMetadataRequest;
import com.amazonaws.services.worklink.model.DescribeFleetMetadataResult;
import com.amazonaws.services.worklink.model.DescribeIdentityProviderConfigurationRequest;
import com.amazonaws.services.worklink.model.DescribeIdentityProviderConfigurationResult;
import com.amazonaws.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest;
import com.amazonaws.services.worklink.model.DescribeWebsiteCertificateAuthorityResult;
import com.amazonaws.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest;
import com.amazonaws.services.worklink.model.DisassociateWebsiteCertificateAuthorityResult;
import com.amazonaws.services.worklink.model.ListDevicesRequest;
import com.amazonaws.services.worklink.model.ListDevicesResult;
import com.amazonaws.services.worklink.model.ListFleetsRequest;
import com.amazonaws.services.worklink.model.ListFleetsResult;
import com.amazonaws.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest;
import com.amazonaws.services.worklink.model.ListWebsiteCertificateAuthoritiesResult;
import com.amazonaws.services.worklink.model.SignOutUserRequest;
import com.amazonaws.services.worklink.model.SignOutUserResult;
import com.amazonaws.services.worklink.model.UpdateAuditStreamConfigurationRequest;
import com.amazonaws.services.worklink.model.UpdateAuditStreamConfigurationResult;
import com.amazonaws.services.worklink.model.UpdateCompanyNetworkConfigurationRequest;
import com.amazonaws.services.worklink.model.UpdateCompanyNetworkConfigurationResult;
import com.amazonaws.services.worklink.model.UpdateDevicePolicyConfigurationRequest;
import com.amazonaws.services.worklink.model.UpdateDevicePolicyConfigurationResult;
import com.amazonaws.services.worklink.model.UpdateFleetMetadataRequest;
import com.amazonaws.services.worklink.model.UpdateFleetMetadataResult;
import com.amazonaws.services.worklink.model.UpdateIdentityProviderConfigurationRequest;
import com.amazonaws.services.worklink.model.UpdateIdentityProviderConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonWorkLinkAsyncClient
extends AmazonWorkLinkClient
implements AmazonWorkLinkAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonWorkLinkAsyncClientBuilder asyncBuilder() {
        return AmazonWorkLinkAsyncClientBuilder.standard();
    }

    AmazonWorkLinkAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateWebsiteCertificateAuthorityResult> associateWebsiteCertificateAuthorityAsync(AssociateWebsiteCertificateAuthorityRequest request) {
        return this.associateWebsiteCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<AssociateWebsiteCertificateAuthorityResult> associateWebsiteCertificateAuthorityAsync(AssociateWebsiteCertificateAuthorityRequest request, final AsyncHandler<AssociateWebsiteCertificateAuthorityRequest, AssociateWebsiteCertificateAuthorityResult> asyncHandler) {
        final AssociateWebsiteCertificateAuthorityRequest finalRequest = (AssociateWebsiteCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateWebsiteCertificateAuthorityResult>(){

            @Override
            public AssociateWebsiteCertificateAuthorityResult call() throws Exception {
                AssociateWebsiteCertificateAuthorityResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeAssociateWebsiteCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {
        return this.createFleetAsync(request, null);
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request, final AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {
        final CreateFleetRequest finalRequest = (CreateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFleetResult>(){

            @Override
            public CreateFleetResult call() throws Exception {
                CreateFleetResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeCreateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request) {
        return this.deleteFleetAsync(request, null);
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request, final AsyncHandler<DeleteFleetRequest, DeleteFleetResult> asyncHandler) {
        final DeleteFleetRequest finalRequest = (DeleteFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFleetResult>(){

            @Override
            public DeleteFleetResult call() throws Exception {
                DeleteFleetResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDeleteFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAuditStreamConfigurationResult> describeAuditStreamConfigurationAsync(DescribeAuditStreamConfigurationRequest request) {
        return this.describeAuditStreamConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeAuditStreamConfigurationResult> describeAuditStreamConfigurationAsync(DescribeAuditStreamConfigurationRequest request, final AsyncHandler<DescribeAuditStreamConfigurationRequest, DescribeAuditStreamConfigurationResult> asyncHandler) {
        final DescribeAuditStreamConfigurationRequest finalRequest = (DescribeAuditStreamConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAuditStreamConfigurationResult>(){

            @Override
            public DescribeAuditStreamConfigurationResult call() throws Exception {
                DescribeAuditStreamConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeAuditStreamConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCompanyNetworkConfigurationResult> describeCompanyNetworkConfigurationAsync(DescribeCompanyNetworkConfigurationRequest request) {
        return this.describeCompanyNetworkConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeCompanyNetworkConfigurationResult> describeCompanyNetworkConfigurationAsync(DescribeCompanyNetworkConfigurationRequest request, final AsyncHandler<DescribeCompanyNetworkConfigurationRequest, DescribeCompanyNetworkConfigurationResult> asyncHandler) {
        final DescribeCompanyNetworkConfigurationRequest finalRequest = (DescribeCompanyNetworkConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCompanyNetworkConfigurationResult>(){

            @Override
            public DescribeCompanyNetworkConfigurationResult call() throws Exception {
                DescribeCompanyNetworkConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeCompanyNetworkConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request) {
        return this.describeDeviceAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request, final AsyncHandler<DescribeDeviceRequest, DescribeDeviceResult> asyncHandler) {
        final DescribeDeviceRequest finalRequest = (DescribeDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceResult>(){

            @Override
            public DescribeDeviceResult call() throws Exception {
                DescribeDeviceResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDevicePolicyConfigurationResult> describeDevicePolicyConfigurationAsync(DescribeDevicePolicyConfigurationRequest request) {
        return this.describeDevicePolicyConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeDevicePolicyConfigurationResult> describeDevicePolicyConfigurationAsync(DescribeDevicePolicyConfigurationRequest request, final AsyncHandler<DescribeDevicePolicyConfigurationRequest, DescribeDevicePolicyConfigurationResult> asyncHandler) {
        final DescribeDevicePolicyConfigurationRequest finalRequest = (DescribeDevicePolicyConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDevicePolicyConfigurationResult>(){

            @Override
            public DescribeDevicePolicyConfigurationResult call() throws Exception {
                DescribeDevicePolicyConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeDevicePolicyConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetMetadataResult> describeFleetMetadataAsync(DescribeFleetMetadataRequest request) {
        return this.describeFleetMetadataAsync(request, null);
    }

    @Override
    public Future<DescribeFleetMetadataResult> describeFleetMetadataAsync(DescribeFleetMetadataRequest request, final AsyncHandler<DescribeFleetMetadataRequest, DescribeFleetMetadataResult> asyncHandler) {
        final DescribeFleetMetadataRequest finalRequest = (DescribeFleetMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFleetMetadataResult>(){

            @Override
            public DescribeFleetMetadataResult call() throws Exception {
                DescribeFleetMetadataResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeFleetMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityProviderConfigurationResult> describeIdentityProviderConfigurationAsync(DescribeIdentityProviderConfigurationRequest request) {
        return this.describeIdentityProviderConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityProviderConfigurationResult> describeIdentityProviderConfigurationAsync(DescribeIdentityProviderConfigurationRequest request, final AsyncHandler<DescribeIdentityProviderConfigurationRequest, DescribeIdentityProviderConfigurationResult> asyncHandler) {
        final DescribeIdentityProviderConfigurationRequest finalRequest = (DescribeIdentityProviderConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityProviderConfigurationResult>(){

            @Override
            public DescribeIdentityProviderConfigurationResult call() throws Exception {
                DescribeIdentityProviderConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeIdentityProviderConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWebsiteCertificateAuthorityResult> describeWebsiteCertificateAuthorityAsync(DescribeWebsiteCertificateAuthorityRequest request) {
        return this.describeWebsiteCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<DescribeWebsiteCertificateAuthorityResult> describeWebsiteCertificateAuthorityAsync(DescribeWebsiteCertificateAuthorityRequest request, final AsyncHandler<DescribeWebsiteCertificateAuthorityRequest, DescribeWebsiteCertificateAuthorityResult> asyncHandler) {
        final DescribeWebsiteCertificateAuthorityRequest finalRequest = (DescribeWebsiteCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWebsiteCertificateAuthorityResult>(){

            @Override
            public DescribeWebsiteCertificateAuthorityResult call() throws Exception {
                DescribeWebsiteCertificateAuthorityResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDescribeWebsiteCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateWebsiteCertificateAuthorityResult> disassociateWebsiteCertificateAuthorityAsync(DisassociateWebsiteCertificateAuthorityRequest request) {
        return this.disassociateWebsiteCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<DisassociateWebsiteCertificateAuthorityResult> disassociateWebsiteCertificateAuthorityAsync(DisassociateWebsiteCertificateAuthorityRequest request, final AsyncHandler<DisassociateWebsiteCertificateAuthorityRequest, DisassociateWebsiteCertificateAuthorityResult> asyncHandler) {
        final DisassociateWebsiteCertificateAuthorityRequest finalRequest = (DisassociateWebsiteCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateWebsiteCertificateAuthorityResult>(){

            @Override
            public DisassociateWebsiteCertificateAuthorityResult call() throws Exception {
                DisassociateWebsiteCertificateAuthorityResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeDisassociateWebsiteCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        final ListDevicesRequest finalRequest = (ListDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeListDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request) {
        return this.listFleetsAsync(request, null);
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request, final AsyncHandler<ListFleetsRequest, ListFleetsResult> asyncHandler) {
        final ListFleetsRequest finalRequest = (ListFleetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFleetsResult>(){

            @Override
            public ListFleetsResult call() throws Exception {
                ListFleetsResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeListFleets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWebsiteCertificateAuthoritiesResult> listWebsiteCertificateAuthoritiesAsync(ListWebsiteCertificateAuthoritiesRequest request) {
        return this.listWebsiteCertificateAuthoritiesAsync(request, null);
    }

    @Override
    public Future<ListWebsiteCertificateAuthoritiesResult> listWebsiteCertificateAuthoritiesAsync(ListWebsiteCertificateAuthoritiesRequest request, final AsyncHandler<ListWebsiteCertificateAuthoritiesRequest, ListWebsiteCertificateAuthoritiesResult> asyncHandler) {
        final ListWebsiteCertificateAuthoritiesRequest finalRequest = (ListWebsiteCertificateAuthoritiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWebsiteCertificateAuthoritiesResult>(){

            @Override
            public ListWebsiteCertificateAuthoritiesResult call() throws Exception {
                ListWebsiteCertificateAuthoritiesResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeListWebsiteCertificateAuthorities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SignOutUserResult> signOutUserAsync(SignOutUserRequest request) {
        return this.signOutUserAsync(request, null);
    }

    @Override
    public Future<SignOutUserResult> signOutUserAsync(SignOutUserRequest request, final AsyncHandler<SignOutUserRequest, SignOutUserResult> asyncHandler) {
        final SignOutUserRequest finalRequest = (SignOutUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SignOutUserResult>(){

            @Override
            public SignOutUserResult call() throws Exception {
                SignOutUserResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeSignOutUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAuditStreamConfigurationResult> updateAuditStreamConfigurationAsync(UpdateAuditStreamConfigurationRequest request) {
        return this.updateAuditStreamConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateAuditStreamConfigurationResult> updateAuditStreamConfigurationAsync(UpdateAuditStreamConfigurationRequest request, final AsyncHandler<UpdateAuditStreamConfigurationRequest, UpdateAuditStreamConfigurationResult> asyncHandler) {
        final UpdateAuditStreamConfigurationRequest finalRequest = (UpdateAuditStreamConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAuditStreamConfigurationResult>(){

            @Override
            public UpdateAuditStreamConfigurationResult call() throws Exception {
                UpdateAuditStreamConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeUpdateAuditStreamConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCompanyNetworkConfigurationResult> updateCompanyNetworkConfigurationAsync(UpdateCompanyNetworkConfigurationRequest request) {
        return this.updateCompanyNetworkConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateCompanyNetworkConfigurationResult> updateCompanyNetworkConfigurationAsync(UpdateCompanyNetworkConfigurationRequest request, final AsyncHandler<UpdateCompanyNetworkConfigurationRequest, UpdateCompanyNetworkConfigurationResult> asyncHandler) {
        final UpdateCompanyNetworkConfigurationRequest finalRequest = (UpdateCompanyNetworkConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCompanyNetworkConfigurationResult>(){

            @Override
            public UpdateCompanyNetworkConfigurationResult call() throws Exception {
                UpdateCompanyNetworkConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeUpdateCompanyNetworkConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDevicePolicyConfigurationResult> updateDevicePolicyConfigurationAsync(UpdateDevicePolicyConfigurationRequest request) {
        return this.updateDevicePolicyConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateDevicePolicyConfigurationResult> updateDevicePolicyConfigurationAsync(UpdateDevicePolicyConfigurationRequest request, final AsyncHandler<UpdateDevicePolicyConfigurationRequest, UpdateDevicePolicyConfigurationResult> asyncHandler) {
        final UpdateDevicePolicyConfigurationRequest finalRequest = (UpdateDevicePolicyConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDevicePolicyConfigurationResult>(){

            @Override
            public UpdateDevicePolicyConfigurationResult call() throws Exception {
                UpdateDevicePolicyConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeUpdateDevicePolicyConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFleetMetadataResult> updateFleetMetadataAsync(UpdateFleetMetadataRequest request) {
        return this.updateFleetMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateFleetMetadataResult> updateFleetMetadataAsync(UpdateFleetMetadataRequest request, final AsyncHandler<UpdateFleetMetadataRequest, UpdateFleetMetadataResult> asyncHandler) {
        final UpdateFleetMetadataRequest finalRequest = (UpdateFleetMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFleetMetadataResult>(){

            @Override
            public UpdateFleetMetadataResult call() throws Exception {
                UpdateFleetMetadataResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeUpdateFleetMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIdentityProviderConfigurationResult> updateIdentityProviderConfigurationAsync(UpdateIdentityProviderConfigurationRequest request) {
        return this.updateIdentityProviderConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateIdentityProviderConfigurationResult> updateIdentityProviderConfigurationAsync(UpdateIdentityProviderConfigurationRequest request, final AsyncHandler<UpdateIdentityProviderConfigurationRequest, UpdateIdentityProviderConfigurationResult> asyncHandler) {
        final UpdateIdentityProviderConfigurationRequest finalRequest = (UpdateIdentityProviderConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateIdentityProviderConfigurationResult>(){

            @Override
            public UpdateIdentityProviderConfigurationResult call() throws Exception {
                UpdateIdentityProviderConfigurationResult result = null;
                try {
                    result = AmazonWorkLinkAsyncClient.this.executeUpdateIdentityProviderConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

