/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.DefinitionType;
import com.amazonaws.services.wellarchitected.model.TrustedAdvisorIntegrationStatus;
import com.amazonaws.services.wellarchitected.model.transform.WorkloadDiscoveryConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkloadDiscoveryConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String trustedAdvisorIntegrationStatus;
    private List<String> workloadResourceDefinition;

    public void setTrustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
        this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
    }

    public String getTrustedAdvisorIntegrationStatus() {
        return this.trustedAdvisorIntegrationStatus;
    }

    public WorkloadDiscoveryConfig withTrustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
        this.setTrustedAdvisorIntegrationStatus(trustedAdvisorIntegrationStatus);
        return this;
    }

    public WorkloadDiscoveryConfig withTrustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus) {
        this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus.toString();
        return this;
    }

    public List<String> getWorkloadResourceDefinition() {
        return this.workloadResourceDefinition;
    }

    public void setWorkloadResourceDefinition(Collection<String> workloadResourceDefinition) {
        if (workloadResourceDefinition == null) {
            this.workloadResourceDefinition = null;
            return;
        }
        this.workloadResourceDefinition = new ArrayList<String>(workloadResourceDefinition);
    }

    public WorkloadDiscoveryConfig withWorkloadResourceDefinition(String ... workloadResourceDefinition) {
        if (this.workloadResourceDefinition == null) {
            this.setWorkloadResourceDefinition(new ArrayList<String>(workloadResourceDefinition.length));
        }
        for (String ele : workloadResourceDefinition) {
            this.workloadResourceDefinition.add(ele);
        }
        return this;
    }

    public WorkloadDiscoveryConfig withWorkloadResourceDefinition(Collection<String> workloadResourceDefinition) {
        this.setWorkloadResourceDefinition(workloadResourceDefinition);
        return this;
    }

    public WorkloadDiscoveryConfig withWorkloadResourceDefinition(DefinitionType ... workloadResourceDefinition) {
        ArrayList<String> workloadResourceDefinitionCopy = new ArrayList<String>(workloadResourceDefinition.length);
        for (DefinitionType value : workloadResourceDefinition) {
            workloadResourceDefinitionCopy.add(value.toString());
        }
        if (this.getWorkloadResourceDefinition() == null) {
            this.setWorkloadResourceDefinition(workloadResourceDefinitionCopy);
        } else {
            this.getWorkloadResourceDefinition().addAll(workloadResourceDefinitionCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrustedAdvisorIntegrationStatus() != null) {
            sb.append("TrustedAdvisorIntegrationStatus: ").append(this.getTrustedAdvisorIntegrationStatus()).append(",");
        }
        if (this.getWorkloadResourceDefinition() != null) {
            sb.append("WorkloadResourceDefinition: ").append(this.getWorkloadResourceDefinition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDiscoveryConfig)) {
            return false;
        }
        WorkloadDiscoveryConfig other = (WorkloadDiscoveryConfig)obj;
        if (other.getTrustedAdvisorIntegrationStatus() == null ^ this.getTrustedAdvisorIntegrationStatus() == null) {
            return false;
        }
        if (other.getTrustedAdvisorIntegrationStatus() != null && !other.getTrustedAdvisorIntegrationStatus().equals(this.getTrustedAdvisorIntegrationStatus())) {
            return false;
        }
        if (other.getWorkloadResourceDefinition() == null ^ this.getWorkloadResourceDefinition() == null) {
            return false;
        }
        return other.getWorkloadResourceDefinition() == null || other.getWorkloadResourceDefinition().equals(this.getWorkloadResourceDefinition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrustedAdvisorIntegrationStatus() == null ? 0 : this.getTrustedAdvisorIntegrationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadResourceDefinition() == null ? 0 : this.getWorkloadResourceDefinition().hashCode());
        return hashCode;
    }

    public WorkloadDiscoveryConfig clone() {
        try {
            return (WorkloadDiscoveryConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkloadDiscoveryConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

