/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.WorkloadImprovementStatus;
import com.amazonaws.services.wellarchitected.model.transform.WorkloadSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkloadSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String workloadId;
    private String workloadArn;
    private String workloadName;
    private String owner;
    private Date updatedAt;
    private List<String> lenses;
    private Map<String, Integer> riskCounts;
    private String improvementStatus;

    public void setWorkloadId(String workloadId) {
        this.workloadId = workloadId;
    }

    public String getWorkloadId() {
        return this.workloadId;
    }

    public WorkloadSummary withWorkloadId(String workloadId) {
        this.setWorkloadId(workloadId);
        return this;
    }

    public void setWorkloadArn(String workloadArn) {
        this.workloadArn = workloadArn;
    }

    public String getWorkloadArn() {
        return this.workloadArn;
    }

    public WorkloadSummary withWorkloadArn(String workloadArn) {
        this.setWorkloadArn(workloadArn);
        return this;
    }

    public void setWorkloadName(String workloadName) {
        this.workloadName = workloadName;
    }

    public String getWorkloadName() {
        return this.workloadName;
    }

    public WorkloadSummary withWorkloadName(String workloadName) {
        this.setWorkloadName(workloadName);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public WorkloadSummary withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public WorkloadSummary withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public List<String> getLenses() {
        return this.lenses;
    }

    public void setLenses(Collection<String> lenses) {
        if (lenses == null) {
            this.lenses = null;
            return;
        }
        this.lenses = new ArrayList<String>(lenses);
    }

    public WorkloadSummary withLenses(String ... lenses) {
        if (this.lenses == null) {
            this.setLenses(new ArrayList<String>(lenses.length));
        }
        for (String ele : lenses) {
            this.lenses.add(ele);
        }
        return this;
    }

    public WorkloadSummary withLenses(Collection<String> lenses) {
        this.setLenses(lenses);
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public WorkloadSummary withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public WorkloadSummary addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public WorkloadSummary clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public void setImprovementStatus(String improvementStatus) {
        this.improvementStatus = improvementStatus;
    }

    public String getImprovementStatus() {
        return this.improvementStatus;
    }

    public WorkloadSummary withImprovementStatus(String improvementStatus) {
        this.setImprovementStatus(improvementStatus);
        return this;
    }

    public WorkloadSummary withImprovementStatus(WorkloadImprovementStatus improvementStatus) {
        this.improvementStatus = improvementStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkloadId() != null) {
            sb.append("WorkloadId: ").append(this.getWorkloadId()).append(",");
        }
        if (this.getWorkloadArn() != null) {
            sb.append("WorkloadArn: ").append(this.getWorkloadArn()).append(",");
        }
        if (this.getWorkloadName() != null) {
            sb.append("WorkloadName: ").append(this.getWorkloadName()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getLenses() != null) {
            sb.append("Lenses: ").append(this.getLenses()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts()).append(",");
        }
        if (this.getImprovementStatus() != null) {
            sb.append("ImprovementStatus: ").append(this.getImprovementStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadSummary)) {
            return false;
        }
        WorkloadSummary other = (WorkloadSummary)obj;
        if (other.getWorkloadId() == null ^ this.getWorkloadId() == null) {
            return false;
        }
        if (other.getWorkloadId() != null && !other.getWorkloadId().equals(this.getWorkloadId())) {
            return false;
        }
        if (other.getWorkloadArn() == null ^ this.getWorkloadArn() == null) {
            return false;
        }
        if (other.getWorkloadArn() != null && !other.getWorkloadArn().equals(this.getWorkloadArn())) {
            return false;
        }
        if (other.getWorkloadName() == null ^ this.getWorkloadName() == null) {
            return false;
        }
        if (other.getWorkloadName() != null && !other.getWorkloadName().equals(this.getWorkloadName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getLenses() == null ^ this.getLenses() == null) {
            return false;
        }
        if (other.getLenses() != null && !other.getLenses().equals(this.getLenses())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        if (other.getRiskCounts() != null && !other.getRiskCounts().equals(this.getRiskCounts())) {
            return false;
        }
        if (other.getImprovementStatus() == null ^ this.getImprovementStatus() == null) {
            return false;
        }
        return other.getImprovementStatus() == null || other.getImprovementStatus().equals(this.getImprovementStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkloadId() == null ? 0 : this.getWorkloadId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadArn() == null ? 0 : this.getWorkloadArn().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadName() == null ? 0 : this.getWorkloadName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLenses() == null ? 0 : this.getLenses().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        hashCode = 31 * hashCode + (this.getImprovementStatus() == null ? 0 : this.getImprovementStatus().hashCode());
        return hashCode;
    }

    public WorkloadSummary clone() {
        try {
            return (WorkloadSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkloadSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

