/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.CountryCode;
import com.amazonaws.services.wafv2.model.ForwardedIPConfig;
import com.amazonaws.services.wafv2.model.transform.GeoMatchStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeoMatchStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> countryCodes;
    private ForwardedIPConfig forwardedIPConfig;

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(Collection<String> countryCodes) {
        if (countryCodes == null) {
            this.countryCodes = null;
            return;
        }
        this.countryCodes = new ArrayList<String>(countryCodes);
    }

    public GeoMatchStatement withCountryCodes(String ... countryCodes) {
        if (this.countryCodes == null) {
            this.setCountryCodes(new ArrayList<String>(countryCodes.length));
        }
        for (String ele : countryCodes) {
            this.countryCodes.add(ele);
        }
        return this;
    }

    public GeoMatchStatement withCountryCodes(Collection<String> countryCodes) {
        this.setCountryCodes(countryCodes);
        return this;
    }

    public GeoMatchStatement withCountryCodes(CountryCode ... countryCodes) {
        ArrayList<String> countryCodesCopy = new ArrayList<String>(countryCodes.length);
        for (CountryCode value : countryCodes) {
            countryCodesCopy.add(value.toString());
        }
        if (this.getCountryCodes() == null) {
            this.setCountryCodes(countryCodesCopy);
        } else {
            this.getCountryCodes().addAll(countryCodesCopy);
        }
        return this;
    }

    public void setForwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
        this.forwardedIPConfig = forwardedIPConfig;
    }

    public ForwardedIPConfig getForwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public GeoMatchStatement withForwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
        this.setForwardedIPConfig(forwardedIPConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCountryCodes() != null) {
            sb.append("CountryCodes: ").append(this.getCountryCodes()).append(",");
        }
        if (this.getForwardedIPConfig() != null) {
            sb.append("ForwardedIPConfig: ").append(this.getForwardedIPConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchStatement)) {
            return false;
        }
        GeoMatchStatement other = (GeoMatchStatement)obj;
        if (other.getCountryCodes() == null ^ this.getCountryCodes() == null) {
            return false;
        }
        if (other.getCountryCodes() != null && !other.getCountryCodes().equals(this.getCountryCodes())) {
            return false;
        }
        if (other.getForwardedIPConfig() == null ^ this.getForwardedIPConfig() == null) {
            return false;
        }
        return other.getForwardedIPConfig() == null || other.getForwardedIPConfig().equals(this.getForwardedIPConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCountryCodes() == null ? 0 : this.getCountryCodes().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedIPConfig() == null ? 0 : this.getForwardedIPConfig().hashCode());
        return hashCode;
    }

    public GeoMatchStatement clone() {
        try {
            return (GeoMatchStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoMatchStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

