/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.trustedadvisor.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Summary of recommendation for accounts within an Organization
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/OrganizationRecommendationSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OrganizationRecommendationSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ARN of the Recommendation
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     */
    private java.util.List<String> awsServices;
    /**
     * <p>
     * The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * </p>
     */
    private String checkArn;
    /**
     * <p>
     * When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The ID which identifies where the Recommendation was produced
     * </p>
     */
    private String id;
    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     */
    private java.util.Date lastUpdatedAt;
    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     */
    private String lifecycleStage;
    /**
     * <p>
     * The name of the AWS Trusted Advisor Recommendation
     * </p>
     */
    private String name;
    /**
     * <p>
     * The pillar aggregations for cost savings
     * </p>
     */
    private RecommendationPillarSpecificAggregates pillarSpecificAggregates;
    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     */
    private java.util.List<String> pillars;
    /**
     * <p>
     * An aggregation of all resources
     * </p>
     */
    private RecommendationResourcesAggregates resourcesAggregates;
    /**
     * <p>
     * The source of the Recommendation
     * </p>
     */
    private String source;
    /**
     * <p>
     * The status of the Recommendation
     * </p>
     */
    private String status;
    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     */
    private String type;

    /**
     * <p>
     * The ARN of the Recommendation
     * </p>
     * 
     * @param arn
     *        The ARN of the Recommendation
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN of the Recommendation
     * </p>
     * 
     * @return The ARN of the Recommendation
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN of the Recommendation
     * </p>
     * 
     * @param arn
     *        The ARN of the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     * 
     * @return The AWS Services that the Recommendation applies to
     */

    public java.util.List<String> getAwsServices() {
        return awsServices;
    }

    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     * 
     * @param awsServices
     *        The AWS Services that the Recommendation applies to
     */

    public void setAwsServices(java.util.Collection<String> awsServices) {
        if (awsServices == null) {
            this.awsServices = null;
            return;
        }

        this.awsServices = new java.util.ArrayList<String>(awsServices);
    }

    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAwsServices(java.util.Collection)} or {@link #withAwsServices(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param awsServices
     *        The AWS Services that the Recommendation applies to
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withAwsServices(String... awsServices) {
        if (this.awsServices == null) {
            setAwsServices(new java.util.ArrayList<String>(awsServices.length));
        }
        for (String ele : awsServices) {
            this.awsServices.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     * 
     * @param awsServices
     *        The AWS Services that the Recommendation applies to
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withAwsServices(java.util.Collection<String> awsServices) {
        setAwsServices(awsServices);
        return this;
    }

    /**
     * <p>
     * The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * </p>
     * 
     * @param checkArn
     *        The AWS Trusted Advisor Check ARN that relates to the Recommendation
     */

    public void setCheckArn(String checkArn) {
        this.checkArn = checkArn;
    }

    /**
     * <p>
     * The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * </p>
     * 
     * @return The AWS Trusted Advisor Check ARN that relates to the Recommendation
     */

    public String getCheckArn() {
        return this.checkArn;
    }

    /**
     * <p>
     * The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * </p>
     * 
     * @param checkArn
     *        The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withCheckArn(String checkArn) {
        setCheckArn(checkArn);
        return this;
    }

    /**
     * <p>
     * When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * </p>
     * 
     * @param createdAt
     *        When the Recommendation was created, if created by AWS Trusted Advisor Priority
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * </p>
     * 
     * @return When the Recommendation was created, if created by AWS Trusted Advisor Priority
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * </p>
     * 
     * @param createdAt
     *        When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The ID which identifies where the Recommendation was produced
     * </p>
     * 
     * @param id
     *        The ID which identifies where the Recommendation was produced
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The ID which identifies where the Recommendation was produced
     * </p>
     * 
     * @return The ID which identifies where the Recommendation was produced
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The ID which identifies where the Recommendation was produced
     * </p>
     * 
     * @param id
     *        The ID which identifies where the Recommendation was produced
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     * 
     * @param lastUpdatedAt
     *        When the Recommendation was last updated
     */

    public void setLastUpdatedAt(java.util.Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     * 
     * @return When the Recommendation was last updated
     */

    public java.util.Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     * 
     * @param lastUpdatedAt
     *        When the Recommendation was last updated
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withLastUpdatedAt(java.util.Date lastUpdatedAt) {
        setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * 
     * @param lifecycleStage
     *        The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */

    public void setLifecycleStage(String lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * 
     * @return The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */

    public String getLifecycleStage() {
        return this.lifecycleStage;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * 
     * @param lifecycleStage
     *        The lifecycle stage from AWS Trusted Advisor Priority
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationLifecycleStage
     */

    public OrganizationRecommendationSummary withLifecycleStage(String lifecycleStage) {
        setLifecycleStage(lifecycleStage);
        return this;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * 
     * @param lifecycleStage
     *        The lifecycle stage from AWS Trusted Advisor Priority
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationLifecycleStage
     */

    public OrganizationRecommendationSummary withLifecycleStage(RecommendationLifecycleStage lifecycleStage) {
        this.lifecycleStage = lifecycleStage.toString();
        return this;
    }

    /**
     * <p>
     * The name of the AWS Trusted Advisor Recommendation
     * </p>
     * 
     * @param name
     *        The name of the AWS Trusted Advisor Recommendation
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the AWS Trusted Advisor Recommendation
     * </p>
     * 
     * @return The name of the AWS Trusted Advisor Recommendation
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the AWS Trusted Advisor Recommendation
     * </p>
     * 
     * @param name
     *        The name of the AWS Trusted Advisor Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The pillar aggregations for cost savings
     * </p>
     * 
     * @param pillarSpecificAggregates
     *        The pillar aggregations for cost savings
     */

    public void setPillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates) {
        this.pillarSpecificAggregates = pillarSpecificAggregates;
    }

    /**
     * <p>
     * The pillar aggregations for cost savings
     * </p>
     * 
     * @return The pillar aggregations for cost savings
     */

    public RecommendationPillarSpecificAggregates getPillarSpecificAggregates() {
        return this.pillarSpecificAggregates;
    }

    /**
     * <p>
     * The pillar aggregations for cost savings
     * </p>
     * 
     * @param pillarSpecificAggregates
     *        The pillar aggregations for cost savings
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withPillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates) {
        setPillarSpecificAggregates(pillarSpecificAggregates);
        return this;
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * 
     * @return The Pillars that the Recommendation is optimizing
     * @see RecommendationPillar
     */

    public java.util.List<String> getPillars() {
        return pillars;
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * 
     * @param pillars
     *        The Pillars that the Recommendation is optimizing
     * @see RecommendationPillar
     */

    public void setPillars(java.util.Collection<String> pillars) {
        if (pillars == null) {
            this.pillars = null;
            return;
        }

        this.pillars = new java.util.ArrayList<String>(pillars);
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPillars(java.util.Collection)} or {@link #withPillars(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param pillars
     *        The Pillars that the Recommendation is optimizing
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationPillar
     */

    public OrganizationRecommendationSummary withPillars(String... pillars) {
        if (this.pillars == null) {
            setPillars(new java.util.ArrayList<String>(pillars.length));
        }
        for (String ele : pillars) {
            this.pillars.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * 
     * @param pillars
     *        The Pillars that the Recommendation is optimizing
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationPillar
     */

    public OrganizationRecommendationSummary withPillars(java.util.Collection<String> pillars) {
        setPillars(pillars);
        return this;
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * 
     * @param pillars
     *        The Pillars that the Recommendation is optimizing
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationPillar
     */

    public OrganizationRecommendationSummary withPillars(RecommendationPillar... pillars) {
        java.util.ArrayList<String> pillarsCopy = new java.util.ArrayList<String>(pillars.length);
        for (RecommendationPillar value : pillars) {
            pillarsCopy.add(value.toString());
        }
        if (getPillars() == null) {
            setPillars(pillarsCopy);
        } else {
            getPillars().addAll(pillarsCopy);
        }
        return this;
    }

    /**
     * <p>
     * An aggregation of all resources
     * </p>
     * 
     * @param resourcesAggregates
     *        An aggregation of all resources
     */

    public void setResourcesAggregates(RecommendationResourcesAggregates resourcesAggregates) {
        this.resourcesAggregates = resourcesAggregates;
    }

    /**
     * <p>
     * An aggregation of all resources
     * </p>
     * 
     * @return An aggregation of all resources
     */

    public RecommendationResourcesAggregates getResourcesAggregates() {
        return this.resourcesAggregates;
    }

    /**
     * <p>
     * An aggregation of all resources
     * </p>
     * 
     * @param resourcesAggregates
     *        An aggregation of all resources
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationRecommendationSummary withResourcesAggregates(RecommendationResourcesAggregates resourcesAggregates) {
        setResourcesAggregates(resourcesAggregates);
        return this;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * 
     * @param source
     *        The source of the Recommendation
     * @see RecommendationSource
     */

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */

    public String getSource() {
        return this.source;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * 
     * @param source
     *        The source of the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationSource
     */

    public OrganizationRecommendationSummary withSource(String source) {
        setSource(source);
        return this;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * 
     * @param source
     *        The source of the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationSource
     */

    public OrganizationRecommendationSummary withSource(RecommendationSource source) {
        this.source = source.toString();
        return this;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * 
     * @param status
     *        The status of the Recommendation
     * @see RecommendationStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * 
     * @return The status of the Recommendation
     * @see RecommendationStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * 
     * @param status
     *        The status of the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationStatus
     */

    public OrganizationRecommendationSummary withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * 
     * @param status
     *        The status of the Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationStatus
     */

    public OrganizationRecommendationSummary withStatus(RecommendationStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * 
     * @param type
     *        Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @see RecommendationType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * 
     * @return Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @see RecommendationType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * 
     * @param type
     *        Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationType
     */

    public OrganizationRecommendationSummary withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * 
     * @param type
     *        Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationType
     */

    public OrganizationRecommendationSummary withType(RecommendationType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getAwsServices() != null)
            sb.append("AwsServices: ").append(getAwsServices()).append(",");
        if (getCheckArn() != null)
            sb.append("CheckArn: ").append(getCheckArn()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getLastUpdatedAt() != null)
            sb.append("LastUpdatedAt: ").append(getLastUpdatedAt()).append(",");
        if (getLifecycleStage() != null)
            sb.append("LifecycleStage: ").append(getLifecycleStage()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getPillarSpecificAggregates() != null)
            sb.append("PillarSpecificAggregates: ").append(getPillarSpecificAggregates()).append(",");
        if (getPillars() != null)
            sb.append("Pillars: ").append(getPillars()).append(",");
        if (getResourcesAggregates() != null)
            sb.append("ResourcesAggregates: ").append(getResourcesAggregates()).append(",");
        if (getSource() != null)
            sb.append("Source: ").append(getSource()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OrganizationRecommendationSummary == false)
            return false;
        OrganizationRecommendationSummary other = (OrganizationRecommendationSummary) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getAwsServices() == null ^ this.getAwsServices() == null)
            return false;
        if (other.getAwsServices() != null && other.getAwsServices().equals(this.getAwsServices()) == false)
            return false;
        if (other.getCheckArn() == null ^ this.getCheckArn() == null)
            return false;
        if (other.getCheckArn() != null && other.getCheckArn().equals(this.getCheckArn()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null)
            return false;
        if (other.getLastUpdatedAt() != null && other.getLastUpdatedAt().equals(this.getLastUpdatedAt()) == false)
            return false;
        if (other.getLifecycleStage() == null ^ this.getLifecycleStage() == null)
            return false;
        if (other.getLifecycleStage() != null && other.getLifecycleStage().equals(this.getLifecycleStage()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getPillarSpecificAggregates() == null ^ this.getPillarSpecificAggregates() == null)
            return false;
        if (other.getPillarSpecificAggregates() != null && other.getPillarSpecificAggregates().equals(this.getPillarSpecificAggregates()) == false)
            return false;
        if (other.getPillars() == null ^ this.getPillars() == null)
            return false;
        if (other.getPillars() != null && other.getPillars().equals(this.getPillars()) == false)
            return false;
        if (other.getResourcesAggregates() == null ^ this.getResourcesAggregates() == null)
            return false;
        if (other.getResourcesAggregates() != null && other.getResourcesAggregates().equals(this.getResourcesAggregates()) == false)
            return false;
        if (other.getSource() == null ^ this.getSource() == null)
            return false;
        if (other.getSource() != null && other.getSource().equals(this.getSource()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getAwsServices() == null) ? 0 : getAwsServices().hashCode());
        hashCode = prime * hashCode + ((getCheckArn() == null) ? 0 : getCheckArn().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedAt() == null) ? 0 : getLastUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getLifecycleStage() == null) ? 0 : getLifecycleStage().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getPillarSpecificAggregates() == null) ? 0 : getPillarSpecificAggregates().hashCode());
        hashCode = prime * hashCode + ((getPillars() == null) ? 0 : getPillars().hashCode());
        hashCode = prime * hashCode + ((getResourcesAggregates() == null) ? 0 : getResourcesAggregates().hashCode());
        hashCode = prime * hashCode + ((getSource() == null) ? 0 : getSource().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public OrganizationRecommendationSummary clone() {
        try {
            return (OrganizationRecommendationSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.trustedadvisor.model.transform.OrganizationRecommendationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
