/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transfer.model.ListedCertificate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCertificatesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ListedCertificate> certificates;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCertificatesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ListedCertificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Collection<ListedCertificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
            return;
        }
        this.certificates = new ArrayList<ListedCertificate>(certificates);
    }

    public ListCertificatesResult withCertificates(ListedCertificate ... certificates) {
        if (this.certificates == null) {
            this.setCertificates(new ArrayList<ListedCertificate>(certificates.length));
        }
        for (ListedCertificate ele : certificates) {
            this.certificates.add(ele);
        }
        return this;
    }

    public ListCertificatesResult withCertificates(Collection<ListedCertificate> certificates) {
        this.setCertificates(certificates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getCertificates() != null) {
            sb.append("Certificates: ").append(this.getCertificates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResult)) {
            return false;
        }
        ListCertificatesResult other = (ListCertificatesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        return other.getCertificates() == null || other.getCertificates().equals(this.getCertificates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : this.getCertificates().hashCode());
        return hashCode;
    }

    public ListCertificatesResult clone() {
        try {
            return (ListCertificatesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

