/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transfer.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeConnector" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeConnectorResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The structure that contains the details of the connector.
     * </p>
     */
    private DescribedConnector connector;

    /**
     * <p>
     * The structure that contains the details of the connector.
     * </p>
     * 
     * @param connector
     *        The structure that contains the details of the connector.
     */

    public void setConnector(DescribedConnector connector) {
        this.connector = connector;
    }

    /**
     * <p>
     * The structure that contains the details of the connector.
     * </p>
     * 
     * @return The structure that contains the details of the connector.
     */

    public DescribedConnector getConnector() {
        return this.connector;
    }

    /**
     * <p>
     * The structure that contains the details of the connector.
     * </p>
     * 
     * @param connector
     *        The structure that contains the details of the connector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeConnectorResult withConnector(DescribedConnector connector) {
        setConnector(connector);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConnector() != null)
            sb.append("Connector: ").append(getConnector());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeConnectorResult == false)
            return false;
        DescribeConnectorResult other = (DescribeConnectorResult) obj;
        if (other.getConnector() == null ^ this.getConnector() == null)
            return false;
        if (other.getConnector() != null && other.getConnector().equals(this.getConnector()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getConnector() == null) ? 0 : getConnector().hashCode());
        return hashCode;
    }

    @Override
    public DescribeConnectorResult clone() {
        try {
            return (DescribeConnectorResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
